/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.db.impl;

import ch.inftec.ju.db.DbRow;
import ch.inftec.ju.db.DbRowUtils;
import junit.framework.Assert;
import org.junit.Test;

public class DbRowUtilsTest {
    @Test
    public void testEqualsAndHashCode() {
        DbRowUtils.DbRowBuilder r1Builder = DbRowUtils.newDbRow();
        DbRowUtils.DbRowBuilder r2Builder = DbRowUtils.newDbRow();
        r1Builder.addValue("col1", 1, (Object)1);
        Assert.assertFalse((boolean)r1Builder.getRow().equals((Object)r2Builder.getRow()));
        Assert.assertFalse((r1Builder.getRow().hashCode() == r2Builder.getRow().hashCode() ? 1 : 0) != 0);
        r2Builder.addValue("col2", 2, (Object)2);
        Assert.assertFalse((boolean)r1Builder.getRow().equals((Object)r2Builder.getRow()));
        Assert.assertFalse((r1Builder.getRow().hashCode() == r2Builder.getRow().hashCode() ? 1 : 0) != 0);
        r1Builder.addValue("col2", 2, (Object)2);
        r2Builder.addValue("col1", 1, (Object)1);
        Assert.assertFalse((boolean)r1Builder.getRow().equals((Object)r2Builder.getRow()));
        Assert.assertFalse((r1Builder.getRow().hashCode() == r2Builder.getRow().hashCode() ? 1 : 0) != 0);
        DbRowUtils.DbRowBuilder r3Builder = DbRowUtils.newDbRow();
        r3Builder.addValue("col1", 1, (Object)1);
        r3Builder.addValue("col2", 2, (Object)2);
        Assert.assertTrue((r1Builder.getRow().hashCode() == r3Builder.getRow().hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)r1Builder.getRow().equals((Object)r3Builder.getRow()));
        Assert.assertTrue((boolean)r3Builder.getRow().equals((Object)r1Builder.getRow()));
        Assert.assertTrue((boolean)r1Builder.getRow().equals((Object)r1Builder.getRow()));
        Assert.assertFalse((boolean)r1Builder.getRow().equals(null));
        Assert.assertFalse((boolean)r1Builder.getRow().equals((Object)this));
    }

    @Test
    public void testUpperAndLowerCase() {
        DbRow row = DbRowUtils.newDbRow().addValue("lower", 1, (Object)"lower").addValue("Mixed", 1, (Object)"Mixed").addValue("UPPER", 1, (Object)"UPPER").getRow();
        Assert.assertEquals((String)"LOWER", (String)row.getColumnName(0));
        Assert.assertEquals((String)"MIXED", (String)row.getColumnName(1));
        Assert.assertEquals((String)"UPPER", (String)row.getColumnName(2));
        Assert.assertEquals((Object)"lower", (Object)row.getValue("lower"));
        Assert.assertEquals((Object)"lower", (Object)row.getValue("Lower"));
        Assert.assertEquals((Object)"lower", (Object)row.getValue("LOWER"));
    }

    @Test
    public void testNull() {
        DbRow row = DbRowUtils.newDbRow().addValue("lower", 1, null).getRow();
        Assert.assertNull((Object)row.getValue("lower"));
        Assert.assertNull((Object)row.getValue("something"));
        Assert.assertNull((Object)row.getValue(null));
        try {
            DbRowUtils.newDbRow().addValue(null, 1, null);
            Assert.fail((String)"Adding null column should throw NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

