/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.db.impl;

import ch.inftec.ju.db.ConnectionInfo;
import ch.inftec.ju.db.data.entity.CustomObject;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.sql.DataSource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.transaction.annotation.Transactional;

@ContextConfiguration(locations={"classpath:/ch/inftec/ju/db/ju-util-context.xml"})
@Transactional
@RunWith(value=SpringJUnit4ClassRunner.class)
public class DbConnectionTest {
    @Autowired
    private ConnectionInfo connectionInfo;
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private DataSource dataSource;

    @Before
    public void initDb() {
        this.entityManager.getMetamodel();
    }

    @Test
    public void dbConnection() {
        Assert.assertEquals((Object)"Derby Test DB", (Object)this.connectionInfo.getName());
        Assert.assertNull((Object)this.connectionInfo.getSchema());
        CustomObject o = new CustomObject();
        this.entityManager.persist((Object)o);
        Assert.assertNotNull((Object)o.getId());
    }

    @Test
    public void jdbcTemplate() {
        Assert.assertEquals((long)1L, (long)this.jdbcTemplate.update("insert into CustomObject (id, text) values (-1, 'test')"));
        Map o = this.jdbcTemplate.queryForMap("select id, text from CustomObject where id=-1");
        Assert.assertEquals((Object)-1L, o.get("id"));
        Assert.assertEquals((Object)"test", o.get("text"));
    }

    @Test
    public void dataSource() throws Exception {
        Assert.assertEquals((long)1L, (long)this.jdbcTemplate.update("insert into CustomObject (id, text) values (-1, 'test')"));
        Connection conn = DataSourceUtils.getConnection((DataSource)this.dataSource);
        PreparedStatement stmt = conn.prepareStatement("select count(*) from CustomObject where id=-1");
        ResultSet rs = stmt.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertFalse((boolean)rs.next());
        stmt.close();
        rs.close();
    }
}

