/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.db;

import ch.inftec.ju.db.ConnectionInfoImpl;
import ch.inftec.ju.util.JuUtils;
import ch.inftec.ju.util.SystemPropertyTempSetter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ConnectionInfoImplTest {
    @Before
    public void clearPropertyChain_beforeTests() {
        JuUtils.clearPropertyChain();
    }

    @Test
    public void supports_unencryptedPassword() {
        try (SystemPropertyTempSetter ts = new SystemPropertyTempSetter();){
            ts.setProperty("ju-util.propertyChain.encryption.password", "secretPassword");
            ConnectionInfoImpl ci = new ConnectionInfoImpl();
            ci.setPassword("cCULeUjKiLfBwEgCOKC1g3BasxVDF85c");
            Assert.assertEquals((Object)"cCULeUjKiLfBwEgCOKC1g3BasxVDF85c", (Object)ci.getPassword());
        }
    }

    @Test
    public void supports_encryptedPassword() {
        try (SystemPropertyTempSetter ts = new SystemPropertyTempSetter();){
            ts.setProperty("ju-util.propertyChain.encryption.password", "secretPassword");
            ConnectionInfoImpl ci = new ConnectionInfoImpl();
            ci.setPassword("ENC(cCULeUjKiLfBwEgCOKC1g3BasxVDF85c)");
            Assert.assertEquals((Object)"secretVal", (Object)ci.getPassword());
        }
    }
}

