/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util.persistable;

import ch.inftec.ju.util.JuStringUtils;
import ch.inftec.ju.util.persistable.AttributeObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
public class MementoObject {
    @Id
    @GeneratedValue
    private Long id;
    private String dbName;
    private String type;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date executionTime;
    @OneToMany(targetEntity=AttributeObject.class, mappedBy="parent", cascade={CascadeType.ALL})
    private List<AttributeObject> attributes = new ArrayList<AttributeObject>();
    @ManyToOne
    private MementoObject parent;
    @OneToMany(targetEntity=MementoObject.class, mappedBy="parent", cascade={CascadeType.ALL})
    private List<MementoObject> children = new ArrayList<MementoObject>();

    public Long getId() {
        return this.id;
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getType() {
        return this.type;
    }

    public Date getExecutionTime() {
        return this.executionTime;
    }

    protected void setId(Long id) {
        this.id = id;
    }

    protected void setDbName(String dbName) {
        this.dbName = dbName;
    }

    protected void setType(String type) {
        this.type = type;
    }

    protected void setExecutionTime(Date executionTime) {
        this.executionTime = executionTime;
    }

    public List<AttributeObject> getAttributes() {
        return this.attributes;
    }

    void addAttribute(AttributeObject attribute) {
        this.attributes.add(attribute);
        attribute.setParent(this);
    }

    public MementoObject getParent() {
        return this.parent;
    }

    public List<MementoObject> getChildren() {
        return this.children;
    }

    void addChild(MementoObject child) {
        this.children.add(child);
        child.parent = this;
    }

    public String toString() {
        return JuStringUtils.toString((Object)this, (Object[])new Object[]{"id", this.getId(), "type", this.getType(), "children", this.getChildren()});
    }
}

