/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util.persistable;

import ch.inftec.ju.db.ConnectionInfo;
import ch.inftec.ju.util.JuStringUtils;
import ch.inftec.ju.util.persistable.AttributeObject;
import ch.inftec.ju.util.persistable.GenericMemento;
import ch.inftec.ju.util.persistable.GenericMementoUtils;
import ch.inftec.ju.util.persistable.GenericMementoX;
import ch.inftec.ju.util.persistable.MementoObject;
import ch.inftec.ju.util.persistable.MementoStorage;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.springframework.beans.factory.annotation.Autowired;

public final class DbPersistenceStorage
implements MementoStorage {
    @PersistenceContext
    private EntityManager em;
    @Autowired
    private ConnectionInfo connectionInfo;
    public static final String ATTR_CONNECTION_NAME = ".connectionName";
    public static final String ATTR_EXECUTION_TIME = ".executionTime";

    public Long persistMemento(GenericMemento memento, String type) {
        Long id = null;
        MementoObject mo = this.createMementoObject(memento, type);
        this.em.persist((Object)mo);
        id = mo.getId();
        return id;
    }

    public MementoStorage.GenericMementoItem loadMemento(Long id) {
        MementoObject mo = (MementoObject)this.em.find(MementoObject.class, (Object)id);
        GenericMementoUtils.GenericMementoBuilder builder = GenericMementoUtils.builder();
        this.buildGenericMemento(mo, builder);
        return GenericMementoUtils.newGenericMementoItem((GenericMemento)builder.build(), (Long)id, (String)mo.getType());
    }

    public List<MementoStorage.GenericMementoItem> loadMementos(int maxCount) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    private MementoObject createMementoObject(GenericMemento memento, String type) {
        MementoObject mo = new MementoObject();
        GenericMementoX moX = GenericMementoUtils.asX((GenericMemento)memento);
        mo.setDbName(moX.getStringValue(ATTR_CONNECTION_NAME));
        mo.setExecutionTime(moX.getDateValue(ATTR_EXECUTION_TIME));
        mo.setType(type);
        for (GenericMemento mementoChild : memento.getChildren()) {
            mo.addChild(this.createMementoObject(mementoChild, null));
        }
        for (GenericMemento.MementoAttribute attribute : memento.getAttributes()) {
            AttributeObject attr = new AttributeObject();
            attr.setKey(attribute.getKey());
            attr.setStringValue(attribute.getStringValue());
            attr.setDateValue(attribute.getDateValue());
            attr.setLongValue(attribute.getLongValue());
            mo.addAttribute(attr);
        }
        return mo;
    }

    private void buildGenericMemento(MementoObject mo, GenericMementoUtils.GenericMementoBuilder builder) {
        for (MementoObject mementoChild : mo.getChildren()) {
            GenericMementoUtils.GenericMementoBuilder childBuilder = builder.newChild();
            this.buildGenericMemento(mementoChild, childBuilder);
            childBuilder.childDone();
        }
        for (AttributeObject attr : mo.getAttributes()) {
            builder.add((GenericMemento.MementoAttribute)attr);
        }
    }

    public String toString() {
        return JuStringUtils.toString(DbPersistenceStorage.class, (Object[])new Object[]{"connectionName", this.connectionInfo.getName()});
    }
}

