/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util.change;

import ch.inftec.ju.db.DbConnection;
import ch.inftec.ju.db.DbRow;
import ch.inftec.ju.db.DbRows;
import ch.inftec.ju.db.JuDbException;
import ch.inftec.ju.util.change.DbAction;
import ch.inftec.ju.util.change.DeleteDbRowDbAction;
import ch.inftec.ju.util.change.InsertDbRowDbAction;
import ch.inftec.ju.util.change.UpdateDbRowDbAction;

public final class DbActionUtils {
    public static AbstractActionBuilder newUpdateAction(DbConnection dbConn, String tableName, Object primaryKeyValue) {
        DbRow row = dbConn.getQueryRunner().primaryKeyQuery(tableName, primaryKeyValue);
        if (row == null) {
            throw new IllegalArgumentException("No row found on table " + tableName + " with ID " + primaryKeyValue);
        }
        return new UpdateActionBuilder(dbConn, row, tableName);
    }

    public static AbstractActionBuilder newUpdateAction(DbConnection dbConn, DbRow row, String tableName) {
        return new UpdateActionBuilder(dbConn, row, tableName);
    }

    public static AbstractActionBuilder newInsertAction(DbConnection dbConn, String tableName) {
        return new InsertActionBuilder(dbConn, tableName);
    }

    public static DbAction newDeleteAction(DbConnection dbConn, String tableName, Object primaryKeyValue) {
        DbRow row = dbConn.getQueryRunner().primaryKeyQuery(tableName, primaryKeyValue);
        if (row == null) {
            throw new IllegalArgumentException("No row found on table " + tableName + " with ID " + primaryKeyValue);
        }
        return DbActionUtils.newDeleteAction(dbConn, row, tableName);
    }

    public static DbAction newDeleteAction(DbConnection dbConn, DbRow row, String tableName) {
        return new DeleteDbRowDbAction(dbConn, row, tableName);
    }

    private static final class InsertActionBuilder
    extends AbstractActionBuilder {
        private InsertActionBuilder(DbConnection dbConn, String tableName) {
            super(new InsertDbRowDbAction(dbConn, dbConn.getQueryRunner().emptyRowQuery(tableName), tableName));
        }
    }

    private static final class UpdateActionBuilder
    extends AbstractActionBuilder {
        private UpdateActionBuilder(DbConnection dbConn, DbRow row, String tableName) {
            super(new UpdateDbRowDbAction(dbConn, row, tableName));
        }
    }

    public static abstract class AbstractActionBuilder {
        private final DbAction action;

        private AbstractActionBuilder(DbAction action) {
            this.action = action;
        }

        public AbstractActionBuilder setValue(String columnName, Object value) {
            this.action.setValue(columnName, value);
            return this;
        }

        public final DbAction getAction() {
            return this.action;
        }

        protected static DbRows emptyRowsQuery(DbConnection dbConn, String tableName) throws JuDbException {
            String selectQry = "SELECT * FROM " + tableName + " WHERE 1=0";
            return dbConn.getQueryRunner().query(selectQry, new Object[0]);
        }
    }
}

