/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.db;

import ch.inftec.ju.db.DatabaseMetaDataCallback;
import ch.inftec.ju.db.DbSchemaBuilder;
import ch.inftec.ju.db.DbSpecificHandlerDerby;
import ch.inftec.ju.db.DbSpecificHandlerH2;
import ch.inftec.ju.db.DbSpecificHandlerMySql;
import ch.inftec.ju.db.DbSpecificHandlerOracle;
import ch.inftec.ju.db.DbWork;
import ch.inftec.ju.db.DsWork;
import ch.inftec.ju.db.JuDbException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;

public interface JuConnUtil {
    public DbType getDbType();

    public void doWork(DbWork var1);

    public void doWork(DsWork var1);

    public MetaDataInfo getMetaDataInfo();

    public DbHandler getDbHandler();

    public <T> T extractDatabaseMetaData(DatabaseMetaDataCallback<T> var1);

    public static enum DbType {
        DERBY{

            @Override
            protected DbHandler getDbSpecificHandler(JuConnUtil connUtil) {
                return new DbSpecificHandlerDerby(connUtil);
            }
        }
        ,
        H2{

            @Override
            protected DbHandler getDbSpecificHandler(JuConnUtil connUtil) {
                return new DbSpecificHandlerH2(connUtil);
            }
        }
        ,
        MYSQL{

            @Override
            protected DbHandler getDbSpecificHandler(JuConnUtil connUtil) {
                return new DbSpecificHandlerMySql(connUtil);
            }
        }
        ,
        ORACLE{

            @Override
            protected DbHandler getDbSpecificHandler(JuConnUtil connUtil) {
                return new DbSpecificHandlerOracle(connUtil);
            }
        };


        static DbType evaluateDbType(String productName) {
            if (productName.toLowerCase().contains("derby")) {
                return DERBY;
            }
            if (productName.toLowerCase().contains("h2")) {
                return H2;
            }
            if (productName.toLowerCase().contains("mysql")) {
                return MYSQL;
            }
            if (productName.toLowerCase().contains("oracle")) {
                return ORACLE;
            }
            throw new JuDbException("Unknown DB. Product name: " + productName);
        }

        protected abstract DbHandler getDbSpecificHandler(JuConnUtil var1);
    }

    public static interface DbHandler {
        public String convertTableNameCasing(String var1);

        public List<String> getSequenceNames();

        public Long getNextValueFromSequence(String var1);

        public void resetIdentityGenerationOrSequences(int var1);

        public String wrapInLowerString(String var1);

        public DbSchemaBuilder createSchema();

        public void dropSchema(MetaDataInfo.SchemaInfo var1, String ... var2);
    }

    public static interface MetaDataInfo {
        public String getUserName();

        public String getUrl();

        public List<String> getPrimaryKeyColumns(String var1);

        public List<String> getTableNames();

        public SchemaInfo getSchemaInfo();

        public SchemaInfos getSchemaInfos();

        public static interface SchemaInfo {
            public String getName();

            public String getCatalog();
        }

        public static final class SchemaInfos {
            private final List<SchemaInfo> schemas = new ArrayList<SchemaInfo>();

            void addSchemaInfo(final String name, final String catalog) {
                this.schemas.add(new SchemaInfo(){

                    @Override
                    public String getName() {
                        return name;
                    }

                    @Override
                    public String getCatalog() {
                        return catalog;
                    }
                });
            }

            public Set<String> getSchemaNames() {
                HashSet<String> schemaNames = new HashSet<String>();
                for (SchemaInfo info : this.schemas) {
                    schemaNames.add(info.getName());
                }
                return schemaNames;
            }

            public Set<String> getCatalogs(String schemaName) {
                HashSet<String> catalogs = new HashSet<String>();
                for (SchemaInfo info : this.schemas) {
                    if (!info.getName().equals(schemaName)) continue;
                    catalogs.add(info.getCatalog());
                }
                return catalogs;
            }

            public List<SchemaInfo> getSchemaInfos(String schemaName, String catalog) {
                ArrayList<SchemaInfo> schemaInfos = new ArrayList<SchemaInfo>();
                for (SchemaInfo info : this.schemas) {
                    if (!info.getName().equals(schemaName) || !ObjectUtils.equals((Object)info.getCatalog(), (Object)catalog)) continue;
                    schemaInfos.add(info);
                }
                return schemaInfos;
            }
        }
    }
}

