/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.db;

import ch.inftec.ju.db.DbSpecificHandler;

public class DbSchemaBuilder {
    private final DbSpecificHandler dbSpecificHandler;
    private String name;
    private String password;
    private String userName;
    private boolean defaultGrants = true;
    private boolean jtaRecoveryGrants = false;

    DbSchemaBuilder(DbSpecificHandler dbSpecificHandler) {
        this.dbSpecificHandler = dbSpecificHandler;
    }

    public DbSchemaBuilder name(String name) {
        this.name = name;
        return this;
    }

    public DbSchemaBuilder password(String password) {
        this.password = password;
        return this;
    }

    public DbSchemaBuilder user(String userName) {
        this.userName = userName;
        return this;
    }

    public DbSchemaBuilder jtaRecoveryGrants(boolean jtaRecoveryGrants) {
        this.jtaRecoveryGrants = true;
        return this;
    }

    String getName() {
        return this.name;
    }

    String getPassword() {
        return this.password;
    }

    String getUserName() {
        return this.userName;
    }

    boolean isDefaultGrants() {
        return this.defaultGrants;
    }

    boolean isJtaRecoveryGrants() {
        return this.jtaRecoveryGrants;
    }

    public void create() {
        this.dbSpecificHandler.createSchema(this);
    }
}

