/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.db;

import ch.inftec.ju.db.DbConnectionFactory;
import ch.inftec.ju.db.DbConnectionFactoryImpl;
import ch.inftec.ju.util.JuRuntimeException;
import ch.inftec.ju.util.xml.XPathGetter;
import ch.inftec.ju.util.xml.XmlUtils;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DbConnectionFactoryLoader {
    Logger log = LoggerFactory.getLogger(DbConnectionFactoryLoader.class);

    private DbConnectionFactoryLoader() {
    }

    public static DbConnectionFactory createInstance() {
        return DbConnectionFactoryLoader.createInstance("/META-INF/persistence.xml");
    }

    public static DbConnectionFactory createInstance(String persistenceXmlPath) {
        try {
            return new DbConnectionFactoryLoader().loadFromXml(persistenceXmlPath);
        }
        catch (Exception ex) {
            throw new JuRuntimeException("Couldn't create DbConnectionFactory instance", (Throwable)ex);
        }
    }

    private DbConnectionFactory loadFromXml(String resourceXmlPath) {
        this.log.info("Loading DB connections from XML: " + resourceXmlPath);
        try {
            URL persistenceXmlUrl = DbConnectionFactoryLoader.class.getResource(resourceXmlPath);
            DbConnectionFactoryImpl factory = new DbConnectionFactoryImpl(resourceXmlPath);
            Document doc = XmlUtils.loadXml((URL)persistenceXmlUrl, null);
            XPathGetter xg = new XPathGetter((Node)doc);
            for (XPathGetter xgConn : xg.getGetters("persistence/persistence-unit")) {
                String name = xgConn.getSingle("@name");
                String flagString = xgConn.getSingle("properties/property[@name='ch.inftec.ju.flags']/@value");
                String schemaName = xgConn.getSingle("properties/property[@name='ch.inftec.ju.schemaName']/@value");
                String[] flags = flagString != null ? StringUtils.stripAll((String[])StringUtils.split((String)flagString, (char)',')) : new String[]{};
                factory.addDbConnection(name, schemaName, flags);
            }
            return factory;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Couldn't load connections from XML: " + resourceXmlPath, ex);
        }
    }
}

