/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.db;

import ch.inftec.ju.db.ConnectionInfo;
import ch.inftec.ju.security.JuSecurityUtils;
import ch.inftec.ju.security.JuTextEncryptor;
import ch.inftec.ju.util.GuiUtils;
import ch.inftec.ju.util.JuObjectUtils;
import ch.inftec.ju.util.JuStringUtils;
import ch.inftec.ju.util.JuUtils;
import java.awt.Image;
import java.net.URL;
import javax.swing.Icon;
import org.apache.commons.lang3.ObjectUtils;

public class ConnectionInfoImpl
implements ConnectionInfo {
    private String name;
    private String connectionString;
    private String userName;
    private String password;
    private String schema;
    private Icon icon;
    private Image image;
    private String decryptedPassword;

    public ConnectionInfoImpl() {
    }

    public ConnectionInfoImpl(String name, String connectionString, String userName, String password, String schema, boolean passwordProtected, Icon icon, Image image) {
        this.name = name;
        this.connectionString = connectionString;
        this.userName = userName;
        this.password = password;
        this.schema = schema;
        this.icon = icon;
        this.image = image;
        this.handleEncryptedPassword();
    }

    private void handleEncryptedPassword() {
        this.decryptedPassword = JuSecurityUtils.decryptTaggedValueIfNecessary((String)this.password, (JuTextEncryptor)JuUtils.getDefaultEncryptor());
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getConnectionString() {
        return this.connectionString;
    }

    public void setConnectionString(String connectionString) {
        this.connectionString = connectionString;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Override
    public String getPassword() {
        return this.decryptedPassword;
    }

    public void setPassword(String password) {
        this.password = password;
        this.handleEncryptedPassword();
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public void setIconUrl(URL iconUrl) {
        this.icon = GuiUtils.loadIconResource((URL)iconUrl);
    }

    @Override
    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public void setImageUrl(URL imageUrl) {
        this.image = GuiUtils.loadIconResource((URL)imageUrl).getImage();
    }

    public String toString() {
        return JuStringUtils.toString((Object)this, (Object[])new Object[]{"name", this.getName()});
    }

    @Override
    public int compareTo(ConnectionInfo o) {
        return ObjectUtils.compare((Comparable)((Object)this.getName()), (Comparable)((Object)(o == null ? null : o.getName())));
    }

    public boolean equals(Object o) {
        return this.compareTo((ConnectionInfo)JuObjectUtils.as((Object)o, ConnectionInfo.class)) == 0;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }
}

