/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.db.query;

import ch.inftec.ju.db.JuEmUtil;
import ch.inftec.ju.util.AssertUtil;
import ch.inftec.ju.util.IOUtil;
import ch.inftec.ju.util.JuRuntimeException;
import ch.inftec.ju.util.JuUrl;
import ch.inftec.ju.util.XString;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryUtils {
    public static NativeQueryBuilder createNativeQuery(EntityManager em) {
        return new NativeQueryBuilder(em);
    }

    public static final class NativeQueryBuilder {
        private Logger logger = LoggerFactory.getLogger(QueryUtils.class);
        private final EntityManager em;
        private final JuEmUtil emUtil;
        private String baseQuery;
        private String whereClausePlaceholder = "${whereClause}";
        private String orderByClausePlaceholder = "${orderByClause}";
        private Object filterObject;
        private Set<String> excludedFilterObjectProperties = new HashSet<String>();
        private Map<String, String> attributeMappings = new HashMap<String, String>();
        private Map<String, Object> queryAttributes = new HashMap<String, Object>();
        private List<AttributeOrdering> ordering = new ArrayList<AttributeOrdering>();
        private String defaultPrefix = null;
        private boolean caseInsensitiveSearch = false;
        private boolean wildcardSearch = false;
        private static final char DB_WILDCARD_CHAR = '%';

        private NativeQueryBuilder(EntityManager em) {
            this.em = em;
            this.emUtil = new JuEmUtil(em);
            this.excludedFilterObjectProperties.add("class");
        }

        public NativeQueryBuilder fromResourceRelativeTo(Class<?> clazz, String resourceName) {
            URL url = JuUrl.existingResourceRelativeTo((String)resourceName, clazz);
            this.baseQuery = new IOUtil().loadTextFromUrl(url, new String[0]);
            return this;
        }

        public NativeQueryBuilder defaultPrefix(String prefix) {
            this.defaultPrefix = prefix;
            return this;
        }

        public NativeQueryBuilder wildcardSearch(boolean wildcardSearch) {
            this.wildcardSearch = wildcardSearch;
            return this;
        }

        public NativeQueryBuilder caseInsensitiveSearch(boolean caseInsensitiveSearch) {
            this.caseInsensitiveSearch = caseInsensitiveSearch;
            return this;
        }

        public NativeQueryBuilder filterByObject(Object obj) {
            this.filterObject = obj;
            return this;
        }

        public NativeQueryBuilder attributeMapping(String attributeName, String nameOnDb) {
            this.attributeMappings.put(attributeName, nameOnDb);
            return this;
        }

        public NativeQueryBuilder exludeAttribute(String attributeName) {
            this.excludedFilterObjectProperties.add(attributeName);
            return this;
        }

        public NativeQueryBuilder orderBy(String columnName, Ordering ordering) {
            this.ordering.add(new AttributeOrdering(columnName, ordering));
            return this;
        }

        public NativeQueryBuilder orderBy(AttributeOrdering ... attributeOrderings) {
            for (AttributeOrdering attributeOrdering : attributeOrderings) {
                this.ordering.add(attributeOrdering);
            }
            return this;
        }

        private Query buildQuery() {
            AssertUtil.assertNotEmpty((String)"Base Query was not supplied", (String)this.baseQuery);
            String actualQuery = this.baseQuery;
            if (this.baseQuery.indexOf(this.whereClausePlaceholder) > 0) {
                XString xsWhere = new XString();
                if (this.filterObject != null) {
                    try {
                        BeanInfo bi = Introspector.getBeanInfo(this.filterObject.getClass());
                        for (PropertyDescriptor pd : bi.getPropertyDescriptors()) {
                            String name = pd.getName();
                            if (this.excludedFilterObjectProperties.contains(name)) continue;
                            String mappedName = this.getActualColumnName(name);
                            Method readMethod = pd.getReadMethod();
                            if (readMethod == null && pd.getPropertyType() == Boolean.class) {
                                String methodName = "is" + StringUtils.capitalize((String)pd.getName());
                                try {
                                    readMethod = this.filterObject.getClass().getMethod(methodName, new Class[0]);
                                }
                                catch (NoSuchMethodException ex) {
                                    this.logger.debug(String.format("Couldn't find method %s on object %s", methodName, this.filterObject.getClass()));
                                }
                            }
                            AssertUtil.assertNotNull((String)("Property is not readable: " + pd.getName()), (Object)readMethod);
                            Object value = readMethod.invoke(this.filterObject, new Object[0]);
                            if (value == null) continue;
                            xsWhere.assertEmptyOrText(" AND ");
                            String operator = "=";
                            if (this.wildcardSearch && value instanceof String && value.toString().indexOf(37) >= 0) {
                                operator = " like ";
                            }
                            String convertedColumn = mappedName;
                            if (this.caseInsensitiveSearch && value instanceof String) {
                                convertedColumn = this.emUtil.asConnUtil().getDbHandler().wrapInLowerString(mappedName);
                                value = value.toString().toLowerCase();
                            }
                            xsWhere.addFormatted("%s%s:%s", new Object[]{convertedColumn, operator, mappedName});
                            this.queryAttributes.put(mappedName, value);
                        }
                    }
                    catch (Exception ex) {
                        throw new JuRuntimeException("Couldn't introspect bean", (Throwable)ex);
                    }
                }
                if (xsWhere.isEmpty()) {
                    xsWhere.addText("1 = 1");
                }
                String whereClause = String.format("(%s)", xsWhere.toString());
                while (actualQuery.indexOf(this.whereClausePlaceholder) > 0) {
                    actualQuery = actualQuery.replace(this.whereClausePlaceholder, whereClause);
                }
            }
            if (this.ordering.size() > 0) {
                XString xsOrderBy = new XString();
                for (AttributeOrdering ao : this.ordering) {
                    xsOrderBy.assertEmptyOrText(", ");
                    xsOrderBy.addText(this.getActualColumnName(ao.getAttributeName()));
                    if (ao.getOrdering() != Ordering.DESCENDING) continue;
                    xsOrderBy.addText(" desc");
                }
                while (actualQuery.indexOf(this.orderByClausePlaceholder) > 0) {
                    actualQuery = actualQuery.replace(this.orderByClausePlaceholder, xsOrderBy.toString());
                }
            }
            this.logger.debug(actualQuery);
            Query qry = this.em.createNativeQuery(actualQuery);
            for (String queryAttribute : this.queryAttributes.keySet()) {
                qry.setParameter(queryAttribute, this.queryAttributes.get(queryAttribute));
            }
            return qry;
        }

        private String getActualColumnName(String attributeName) {
            String actualName = attributeName;
            if (this.attributeMappings.containsKey(attributeName)) {
                actualName = this.attributeMappings.get(attributeName);
            }
            if (!StringUtils.isEmpty((CharSequence)this.defaultPrefix) && !actualName.contains(".")) {
                actualName = String.format("%s.%s", this.defaultPrefix, actualName);
            }
            return actualName;
        }

        public Query createQuery() {
            return this.buildQuery();
        }

        public static enum Ordering {
            ASCENDING,
            DESCENDING;

        }

        public static final class AttributeOrdering {
            private final String attributeName;
            private final Ordering ordering;

            public AttributeOrdering(String attributeName, Ordering ordering) {
                this.attributeName = attributeName;
                this.ordering = ordering;
            }

            public String getAttributeName() {
                return this.attributeName;
            }

            public Ordering getOrdering() {
                return this.ordering;
            }
        }
    }
}

