/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.db;

import ch.inftec.ju.db.JuDbException;
import javax.persistence.EntityManager;
import javax.transaction.UserTransaction;

public final class TxHandler
implements AutoCloseable {
    private final EntityManager em;
    private final UserTransaction tx;
    private boolean committed = true;

    public TxHandler(UserTransaction tx) {
        this(tx, true);
    }

    public TxHandler(EntityManager em) {
        this(em, null, true);
    }

    public TxHandler(UserTransaction tx, boolean begin) {
        this(null, tx, begin);
    }

    private TxHandler(EntityManager em, UserTransaction tx, boolean begin) {
        this.em = em;
        this.tx = tx;
        if (begin) {
            this.begin();
        }
    }

    public void begin() {
        if (this.em != null) {
            if (!this.em.getTransaction().isActive()) {
                this.em.getTransaction().begin();
            }
        } else {
            try {
                if (this.tx != null && this.tx.getStatus() != 0) {
                    this.tx.begin();
                }
                this.committed = false;
            }
            catch (Exception ex) {
                throw new JuDbException("Couldn't begin JTA transaction", ex);
            }
        }
    }

    public void commit() {
        this.commit(false);
    }

    public void commit(boolean beginNew) {
        if (this.em != null) {
            if (!this.committed) {
                this.em.getTransaction().commit();
                this.committed = true;
            }
            if (beginNew) {
                this.em.getTransaction().begin();
            }
        } else {
            try {
                if (!this.committed) {
                    if (this.tx != null) {
                        this.tx.commit();
                    }
                    this.committed = true;
                }
            }
            catch (Exception ex) {
                throw new JuDbException("Couldn't commit JTA transaction", ex);
            }
            if (beginNew) {
                this.begin();
            }
        }
    }

    public void rollbackIfNotCommitted() {
        if (!this.committed) {
            if (this.em != null) {
                this.em.getTransaction().rollback();
            } else if (this.tx != null) {
                try {
                    this.tx.rollback();
                }
                catch (Exception ex) {
                    throw new JuDbException("Couldn't rollback transaction", ex);
                }
            }
            this.committed = true;
        }
    }

    @Override
    public void close() {
        this.rollbackIfNotCommitted();
    }
}

