/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.db;

import ch.inftec.ju.db.EmfWork;
import ch.inftec.ju.db.JuEmUtil;
import ch.inftec.ju.util.AssertUtil;
import ch.inftec.ju.util.XString;
import java.util.HashMap;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.apache.commons.lang3.StringUtils;

public class JuEmfUtil {
    private final EntityManagerFactory emf;

    public JuEmfUtil(EntityManagerFactory emf) {
        this.emf = emf;
    }

    public EmfWork startWork() {
        EntityManager em = this.emf.createEntityManager();
        return new EmfWorkImpl(em);
    }

    public static JuEmfUtilBuilder create() {
        return new JuEmfUtilBuilder();
    }

    private static class EmfWorkImpl
    implements EmfWork {
        private final EntityManager em;
        private boolean rollbackOnly = false;

        public EmfWorkImpl(EntityManager em) {
            this.em = em;
            this.em.getTransaction().begin();
        }

        @Override
        public EntityManager getEm() {
            return this.em;
        }

        @Override
        public JuEmUtil getEmUtil() {
            return new JuEmUtil(this.em);
        }

        @Override
        public void setRollbackOnly() {
            this.rollbackOnly = true;
        }

        @Override
        public void close() {
            if (this.em.getTransaction().isActive()) {
                if (this.rollbackOnly) {
                    this.em.getTransaction().rollback();
                } else {
                    this.em.getTransaction().commit();
                }
            }
            this.em.close();
        }
    }

    public static class JuEmfUtilBuilder {
        private static HashMap<XString, JuEmfUtil> emfUtils = new HashMap();
        private String persistenceUnitName;
        private String connectionUrl;
        private String user;
        private String password;

        public JuEmfUtilBuilder persistenceUnitName(String persistenceUnitName) {
            this.persistenceUnitName = persistenceUnitName;
            return this;
        }

        public JuEmfUtilBuilder user(String user) {
            this.user = user;
            return this;
        }

        public JuEmfUtilBuilder password(String password) {
            this.password = password;
            return this;
        }

        public JuEmfUtilBuilder connectionUrl(String connectionUrl) {
            this.connectionUrl = connectionUrl;
            return this;
        }

        public JuEmfUtil build() {
            AssertUtil.assertNotEmpty((String)"PersistenceUnit name must be specified", (String)this.persistenceUnitName);
            XString xs = new XString();
            xs.addItems("|", new Object[]{this.persistenceUnitName, this.connectionUrl});
            if (!emfUtils.containsKey(xs)) {
                String dialect = null;
                String driver = null;
                if (!StringUtils.isEmpty((CharSequence)this.connectionUrl)) {
                    if (this.connectionUrl.startsWith("jdbc:derby")) {
                        dialect = "org.hibernate.dialect.DerbyTenSevenDialect";
                        driver = "org.apache.derby.jdbc.EmbeddedDriver";
                    } else if (this.connectionUrl.startsWith("jdbc:h2")) {
                        dialect = "org.hibernate.dialect.H2Dialect";
                        driver = "org.h2.Driver";
                    } else if (this.connectionUrl.startsWith("jdbc:mysql")) {
                        dialect = "org.hibernate.dialect.MySQLDialect";
                        driver = "com.mysql.jdbc.Driver";
                    } else if (this.connectionUrl.startsWith("jdbc:oracle:thin")) {
                        dialect = "org.hibernate.dialect.Oracle10gDialect";
                        driver = "oracle.jdbc.OracleDriver";
                    } else {
                        throw new IllegalStateException("Cannot evaluate DB type from connection URL " + this.connectionUrl);
                    }
                }
                HashMap<String, String> props = new HashMap<String, String>();
                if (dialect != null) {
                    props.put("hibernate.dialect", dialect);
                }
                if (driver != null) {
                    props.put("javax.persistence.jdbc.driver", driver);
                }
                if (this.connectionUrl != null) {
                    props.put("javax.persistence.jdbc.url", this.connectionUrl);
                }
                if (this.user != null) {
                    props.put("javax.persistence.jdbc.user", this.user);
                }
                if (this.password != null) {
                    props.put("javax.persistence.jdbc.password", this.password);
                }
                EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)this.persistenceUnitName, props);
                emfUtils.put(xs, new JuEmfUtil(emf));
            }
            return emfUtils.get(xs);
        }
    }
}

