/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.db;

import ch.inftec.ju.db.DatabaseMetaDataCallback;
import ch.inftec.ju.db.DbWork;
import ch.inftec.ju.db.DbWorker;
import ch.inftec.ju.db.DsWork;
import ch.inftec.ju.db.JuConnUtil;
import ch.inftec.ju.db.JuConnUtils;
import ch.inftec.ju.db.JuDbException;
import ch.inftec.ju.util.DataHolder;
import java.io.PrintWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.persistence.EntityManager;
import javax.sql.DataSource;
import org.hibernate.Session;
import org.hibernate.ejb.EntityManagerFactoryImpl;
import org.hibernate.ejb.EntityManagerImpl;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.jdbc.Work;
import org.hibernate.service.jdbc.connections.internal.DatasourceConnectionProviderImpl;
import org.hibernate.service.jdbc.connections.spi.ConnectionProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.repository.support.JpaRepositoryFactory;

public class JuEmUtil
implements DbWorker {
    private final Logger logger = LoggerFactory.getLogger(JuEmUtil.class);
    private final EntityManager em;
    private JuConnUtil.DbType dbType;

    public JuEmUtil(EntityManager em) {
        this.em = em;
    }

    public EntityManager getEm() {
        return this.em;
    }

    public JuConnUtil asConnUtil() {
        return JuConnUtils.createByDbWorker(this);
    }

    @Override
    public void doWork(final DbWork work) {
        this.doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                work.execute(connection);
            }
        });
    }

    public void doWork(Work work) {
        this.em.flush();
        Session session = (Session)this.em.unwrap(Session.class);
        session.doWork(work);
    }

    public void doWork(DsWork work) {
        EntityManagerFactoryImpl factory = ((EntityManagerImpl)this.em.unwrap(EntityManagerImpl.class)).getEntityManagerFactory();
        SessionFactoryImpl sessionFactory = (SessionFactoryImpl)factory.getSessionFactory();
        ConnectionProvider connProvider = sessionFactory.getConnectionProvider();
        DataSource ds = null;
        if (connProvider instanceof DatasourceConnectionProviderImpl) {
            ds = ((DatasourceConnectionProviderImpl)connProvider).getDataSource();
            this.logger.debug("Using actual DataSource to execute DataSource work: " + ds);
        } else {
            ds = new ConnectionProviderDataSource(connProvider);
            this.logger.debug("Using ConnectionProviderDataSource to execute DataSource work.");
        }
        work.execute(ds);
    }

    public <T> T getJpaRepository(Class<T> repositoryClass) {
        JpaRepositoryFactory repositoryFactory = new JpaRepositoryFactory(this.em);
        return (T)repositoryFactory.getRepository(repositoryClass);
    }

    public <T> T extractDatabaseMetaData(final DatabaseMetaDataCallback<T> action) {
        final DataHolder res = new DataHolder();
        this.doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                DatabaseMetaData metaData = connection.getMetaData();
                res.setValue(action.processMetaData(metaData));
            }
        });
        return (T)res.getValue();
    }

    public String getMetaDataUrl() {
        return this.extractDatabaseMetaData(new DatabaseMetaDataCallback<String>(){

            @Override
            public String processMetaData(DatabaseMetaData dbmd) throws SQLException {
                return dbmd.getURL();
            }
        });
    }

    public String getMetaDataUserName() {
        return this.extractDatabaseMetaData(new DatabaseMetaDataCallback<String>(){

            @Override
            public String processMetaData(DatabaseMetaData dbmd) throws SQLException {
                return dbmd.getUserName();
            }
        });
    }

    public String getConnectionCatalog() {
        final DataHolder catalog = new DataHolder();
        this.doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                catalog.setValue((Object)connection.getCatalog());
            }
        });
        return (String)catalog.getValue();
    }

    public List<String> getTableNames() throws JuDbException {
        List<String> tableNames = this.extractDatabaseMetaData(new DatabaseMetaDataCallback<List<String>>(){

            @Override
            public List<String> processMetaData(DatabaseMetaData dbmd) throws SQLException {
                String schemaName = null;
                if (JuEmUtil.this.getDbType() == JuConnUtil.DbType.ORACLE) {
                    schemaName = JuEmUtil.this.getMetaDataUserName();
                }
                ResultSet rs = dbmd.getTables(schemaName, schemaName, null, new String[]{"TABLE"});
                ArrayList<String> tableNames = new ArrayList<String>();
                while (rs.next()) {
                    String tableName = rs.getString("TABLE_NAME");
                    if (tableNames.contains(tableName)) continue;
                    tableNames.add(tableName);
                }
                rs.close();
                Collections.sort(tableNames);
                return tableNames;
            }
        });
        return tableNames;
    }

    public List<String> getPrimaryKeyColumns(String tableName) {
        final String actualTableName = this.getDbType().getDbSpecificHandler(this.asConnUtil()).convertTableNameCasing(tableName);
        List<String> columnNames = this.extractDatabaseMetaData(new DatabaseMetaDataCallback<List<String>>(){

            @Override
            public List<String> processMetaData(DatabaseMetaData dbmd) throws SQLException {
                ResultSet rs = dbmd.getPrimaryKeys(null, null, actualTableName);
                ArrayList<String> columnNames = new ArrayList<String>();
                while (rs.next()) {
                    columnNames.add(rs.getString("COLUMN_NAME"));
                }
                rs.close();
                return columnNames;
            }
        });
        return columnNames;
    }

    public List<String> getSequenceNames() throws JuDbException {
        return this.getDbType().getDbSpecificHandler(this.asConnUtil()).getSequenceNames();
    }

    public Long getNextValueFromSequence(String sequenceName) throws JuDbException {
        return this.getDbType().getDbSpecificHandler(this.asConnUtil()).getNextValueFromSequence(sequenceName);
    }

    public void resetIdentityGenerationOrSequences(int val) {
        this.getDbType().getDbSpecificHandler(this.asConnUtil()).resetIdentityGenerationOrSequences(val);
    }

    public JuConnUtil.DbType getDbType() {
        if (this.dbType == null) {
            String productName = this.extractDatabaseMetaData(new DatabaseMetaDataCallback<String>(){

                @Override
                public String processMetaData(DatabaseMetaData dbmd) throws SQLException {
                    return dbmd.getDatabaseProductName();
                }
            });
            this.dbType = JuConnUtil.DbType.evaluateDbType(productName);
        }
        return this.dbType;
    }

    private static class ConnectionProviderDataSource
    implements DataSource {
        private final ConnectionProvider connectionProvider;

        public ConnectionProviderDataSource(ConnectionProvider connProvider) {
            this.connectionProvider = connProvider;
        }

        @Override
        public PrintWriter getLogWriter() throws SQLException {
            throw new UnsupportedOperationException("unwrap");
        }

        @Override
        public void setLogWriter(PrintWriter out) throws SQLException {
            throw new UnsupportedOperationException("unwrap");
        }

        @Override
        public void setLoginTimeout(int seconds) throws SQLException {
            throw new UnsupportedOperationException("unwrap");
        }

        @Override
        public int getLoginTimeout() throws SQLException {
            throw new UnsupportedOperationException("unwrap");
        }

        @Override
        public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
            throw new UnsupportedOperationException("unwrap");
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            throw new UnsupportedOperationException("unwrap");
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            throw new UnsupportedOperationException("unwrap");
        }

        @Override
        public Connection getConnection() throws SQLException {
            Connection conn = this.connectionProvider.getConnection();
            Connection connProxy = (Connection)Proxy.newProxyInstance(Connection.class.getClassLoader(), new Class[]{Connection.class}, (InvocationHandler)new ConnectionInvocationHandler(conn));
            return connProxy;
        }

        @Override
        public Connection getConnection(String username, String password) throws SQLException {
            throw new UnsupportedOperationException("unwrap");
        }

        private class ConnectionInvocationHandler
        implements InvocationHandler {
            private final Connection wrappedConnection;

            private ConnectionInvocationHandler(Connection wrappedConnection) {
                this.wrappedConnection = wrappedConnection;
            }

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getName().equals("close")) {
                    ConnectionProviderDataSource.this.connectionProvider.closeConnection(this.wrappedConnection);
                    return null;
                }
                return method.invoke((Object)this.wrappedConnection, args);
            }
        }
    }
}

