/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.db;

import ch.inftec.ju.db.DatabaseMetaDataCallback;
import ch.inftec.ju.db.DbWork;
import ch.inftec.ju.db.DbWorker;
import ch.inftec.ju.db.DsWork;
import ch.inftec.ju.db.JuConnUtil;
import ch.inftec.ju.util.AssertUtil;
import ch.inftec.ju.util.DataHolder;
import ch.inftec.ju.util.JuRuntimeException;
import ch.inftec.ju.util.JuUtils;
import ch.inftec.ju.util.PropertyChain;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.SingleConnectionDataSource;

public class JuConnUtils {
    public static JuConnUtilBuilder build() {
        return new JuConnUtilBuilder();
    }

    public static JuConnUtil createByDbWorker(final DbWorker worker) {
        return new AbstractJuConnUtil(){

            @Override
            protected void performDbWork(DbWork work) throws SQLException {
                worker.doWork(work);
            }
        };
    }

    public static JuConnUtil createByConnection(final Connection conn) {
        return new AbstractJuConnUtil(){

            @Override
            protected void performDbWork(DbWork work) throws SQLException {
                work.execute(conn);
            }
        };
    }

    public static JuConnUtil createByDataSource(final DataSource ds) {
        return new AbstractJuConnUtil(){

            @Override
            protected void performDbWork(DbWork work) throws SQLException {
                try (Connection conn = ds.getConnection();){
                    work.execute(conn);
                }
            }
        };
    }

    public static JuConnUtil createByDataSource(DataSource ds, boolean recycleConnection) {
        try {
            final Connection conn = ds.getConnection();
            return new AbstractJuConnUtil(){

                @Override
                protected void performDbWork(DbWork work) throws SQLException {
                    work.execute(conn);
                }
            };
        }
        catch (Exception ex) {
            throw new JuRuntimeException("Couldn't get Connection from DataSource", (Throwable)ex);
        }
    }

    public static JdbcTemplate asJdbcTemplate(Connection conn) {
        return new JdbcTemplate((DataSource)new SingleConnectionDataSource(conn, true));
    }

    private static class JdbcConnUtil
    extends AbstractJuConnUtil {
        private final String url;
        private final String user;
        private final String password;

        private JdbcConnUtil(String url, String user, String password) {
            this.url = url;
            this.user = user;
            this.password = password;
        }

        @Override
        public void performDbWork(DbWork work) throws SQLException {
            try (Connection conn = DriverManager.getConnection(this.url, this.user, this.password);){
                work.execute(conn);
            }
        }
    }

    private static final class MetaDataInfoImpl
    implements JuConnUtil.MetaDataInfo {
        private final String userName;
        private final String url;
        private final JuConnUtil connUtil;

        public MetaDataInfoImpl(String userName, String url, JuConnUtil connUtil) {
            this.userName = userName;
            this.url = url;
            this.connUtil = connUtil;
        }

        @Override
        public String getUrl() {
            return this.url;
        }

        @Override
        public String getUserName() {
            return this.userName;
        }

        @Override
        public List<String> getPrimaryKeyColumns(String tableName) {
            final String actualTableName = this.connUtil.getDbType().getDbSpecificHandler(this.connUtil).convertTableNameCasing(tableName);
            List<String> columnNames = this.connUtil.extractDatabaseMetaData(new DatabaseMetaDataCallback<List<String>>(){

                @Override
                public List<String> processMetaData(DatabaseMetaData dbmd) throws SQLException {
                    ResultSet rs = dbmd.getPrimaryKeys(null, null, actualTableName);
                    ArrayList<String> columnNames = new ArrayList<String>();
                    while (rs.next()) {
                        columnNames.add(rs.getString("COLUMN_NAME"));
                    }
                    rs.close();
                    return columnNames;
                }
            });
            return columnNames;
        }

        @Override
        public List<String> getTableNames() {
            List<String> tableNames = this.connUtil.extractDatabaseMetaData(new DatabaseMetaDataCallback<List<String>>(){

                @Override
                public List<String> processMetaData(DatabaseMetaData dbmd) throws SQLException {
                    String schemaName = null;
                    if (MetaDataInfoImpl.this.connUtil.getDbType() == JuConnUtil.DbType.ORACLE) {
                        schemaName = MetaDataInfoImpl.this.getUserName();
                    }
                    ResultSet rs = dbmd.getTables(schemaName, schemaName, null, new String[]{"TABLE"});
                    ArrayList<String> tableNames = new ArrayList<String>();
                    while (rs.next()) {
                        String tableName = rs.getString("TABLE_NAME");
                        if (tableNames.contains(tableName)) continue;
                        tableNames.add(tableName);
                    }
                    rs.close();
                    Collections.sort(tableNames);
                    return tableNames;
                }
            });
            return tableNames;
        }
    }

    private static abstract class AbstractJuConnUtil
    implements JuConnUtil {
        private JuConnUtil.DbType dbType;

        private AbstractJuConnUtil() {
        }

        @Override
        public <T> T extractDatabaseMetaData(final DatabaseMetaDataCallback<T> action) {
            final DataHolder res = new DataHolder();
            this.doWork(new DbWork(){

                @Override
                public void execute(Connection connection) {
                    try {
                        DatabaseMetaData metaData = connection.getMetaData();
                        res.setValue(action.processMetaData(metaData));
                    }
                    catch (Exception ex) {
                        throw new JuRuntimeException("Couldn't get JDBC MetaData", (Throwable)ex);
                    }
                }
            });
            return (T)res.getValue();
        }

        @Override
        public JuConnUtil.DbType getDbType() {
            if (this.dbType == null) {
                String productName = this.extractDatabaseMetaData(new DatabaseMetaDataCallback<String>(){

                    @Override
                    public String processMetaData(DatabaseMetaData dbmd) throws SQLException {
                        return dbmd.getDatabaseProductName();
                    }
                });
                this.dbType = JuConnUtil.DbType.evaluateDbType(productName);
            }
            return this.dbType;
        }

        @Override
        public void doWork(DbWork work) {
            try {
                this.performDbWork(work);
            }
            catch (Exception ex) {
                throw new JuRuntimeException("Couldn't execute DB work", (Throwable)ex);
            }
        }

        protected abstract void performDbWork(DbWork var1) throws SQLException;

        @Override
        public void doWork(final DsWork work) {
            this.doWork(new DbWork(){

                @Override
                public void execute(Connection conn) {
                    work.execute((DataSource)new SingleConnectionDataSource(conn, false));
                }
            });
        }

        @Override
        public JuConnUtil.MetaDataInfo getMetaDataInfo() {
            return this.extractDatabaseMetaData(new DatabaseMetaDataCallback<JuConnUtil.MetaDataInfo>(){

                @Override
                public JuConnUtil.MetaDataInfo processMetaData(DatabaseMetaData dbmd) throws SQLException {
                    return new MetaDataInfoImpl(dbmd.getUserName(), dbmd.getURL(), AbstractJuConnUtil.this);
                }
            });
        }

        @Override
        public JuConnUtil.DbHandler getDbHandler() {
            return this.getDbType().getDbSpecificHandler(this);
        }
    }

    public static final class JuConnUtilBuilder {
        private String url;
        private String user;
        private String password;

        private JuConnUtilBuilder() {
        }

        public JuConnUtilBuilder url(String url) {
            this.url = url;
            return this;
        }

        public JuConnUtilBuilder user(String user) {
            this.user = user;
            return this;
        }

        public JuConnUtilBuilder password(String password) {
            this.password = password;
            return this;
        }

        public JuConnUtilBuilder profile(String profileName) {
            PropertyChain pc = JuUtils.getJuPropertyChain();
            return this.url(pc.get(String.format("ju-dbutil-test.%s.connectionUrl", profileName))).user(pc.get(String.format("ju-dbutil-test.%s.user", profileName))).password(pc.get(String.format("ju-dbutil-test.%s.password", profileName)));
        }

        public JuConnUtil create() {
            AssertUtil.assertNotEmpty((String)"DB URL hasn't been set", (String)this.url);
            return new JdbcConnUtil(this.url, this.user, this.password);
        }
    }
}

