/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.db;

import ch.inftec.ju.db.DbSpecificHandlerDefault;
import ch.inftec.ju.db.DbWork;
import ch.inftec.ju.db.JuConnUtil;
import ch.inftec.ju.db.JuConnUtils;
import ch.inftec.ju.util.ConversionUtils;
import java.sql.Connection;
import java.util.List;
import org.springframework.jdbc.core.JdbcTemplate;

public class DbSpecificHandlerOracle
extends DbSpecificHandlerDefault {
    public DbSpecificHandlerOracle(JuConnUtil connUtil) {
        super(connUtil);
    }

    @Override
    public List<String> getSequenceNames() {
        return this.queryForList("select SEQUENCE_NAME from USER_SEQUENCES", String.class);
    }

    @Override
    public void resetIdentityGenerationOrSequences(final int val) {
        this.connUtil.doWork(new DbWork(){

            @Override
            public void execute(Connection conn) {
                JdbcTemplate jt = JuConnUtils.asJdbcTemplate(conn);
                for (String sequence : DbSpecificHandlerOracle.this.getSequenceNames()) {
                    jt.execute("drop sequence " + sequence);
                    jt.execute(String.format("create sequence %s start with %d", sequence, val));
                }
            }
        });
    }

    @Override
    public Long getNextValueFromSequence(String sequenceName) {
        return ConversionUtils.toLong((Object)this.queryForObject(String.format("select %s.nextVal from dual", sequenceName), Object.class));
    }
}

