/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.db;

import ch.inftec.ju.db.DbSpecificHandlerDefault;
import ch.inftec.ju.db.DbWork;
import ch.inftec.ju.db.JuConnUtil;
import ch.inftec.ju.db.JuConnUtils;
import ch.inftec.ju.util.ConversionUtils;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import org.springframework.jdbc.core.JdbcTemplate;

public class DbSpecificHandlerDerby
extends DbSpecificHandlerDefault {
    public DbSpecificHandlerDerby(JuConnUtil connUtil) {
        super(connUtil);
    }

    @Override
    public List<String> getSequenceNames() {
        return this.queryForList("select SEQUENCENAME name from SYS.SYSSEQUENCES", String.class);
    }

    @Override
    public void resetIdentityGenerationOrSequences(final int val) {
        this.connUtil.doWork(new DbWork(){

            @Override
            public void execute(Connection conn) {
                JdbcTemplate jt = JuConnUtils.asJdbcTemplate(conn);
                List res = jt.queryForList("select t.TABLENAME, c.COLUMNNAME from sys.SYSCOLUMNS c   inner join sys.SYSTABLES t on t.TABLEID = c.REFERENCEID where c.AUTOINCREMENTVALUE is not null");
                for (Map row : res) {
                    String tableName = row.get("TABLENAME").toString();
                    String columnName = row.get("COLUMNNAME").toString();
                    DbSpecificHandlerDerby.this.logger.debug(String.format("Restarting ID column %s.%s with %d", tableName, columnName, val));
                    jt.execute(String.format("alter table %s alter %s restart with %d", tableName, columnName, val));
                }
                for (String sequenceName : DbSpecificHandlerDerby.this.getSequenceNames()) {
                    DbSpecificHandlerDerby.this.logger.debug(String.format("Restarting (crop/create) sequence %s with %d", sequenceName, val));
                    jt.execute(String.format("drop sequence %s restrict", sequenceName));
                    jt.execute(String.format("create sequence %s start with %d", sequenceName, val));
                }
            }
        });
    }

    @Override
    public Long getNextValueFromSequence(String sequenceName) {
        return ConversionUtils.toLong((Object)this.queryForObject(String.format("values next value for %s", sequenceName), Object.class));
    }
}

