/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.db;

import ch.inftec.ju.db.DbConnection;
import ch.inftec.ju.db.DbQueryRunner;
import ch.inftec.ju.db.DbRow;
import ch.inftec.ju.db.DbRowResultSetHandler;
import ch.inftec.ju.db.DbRowUtils;
import ch.inftec.ju.db.JuDbException;
import ch.inftec.ju.db.JuDbUtils;
import ch.inftec.ju.util.JuStringUtils;
import ch.inftec.ju.util.change.DbAction;
import ch.inftec.ju.util.change.DbActionUtils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceUtils;

final class DbConnectionImpl
implements DbConnection {
    Logger log = LoggerFactory.getLogger(DbConnectionImpl.class);
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private DataSource dataSource;
    private String name;
    private String schemaName;

    DbConnectionImpl() {
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getSchemaName() {
        return this.schemaName;
    }

    @Override
    public List<String> getTableNames() throws JuDbException {
        DbMetaData md = new DbMetaData();
        return md.getTableNames();
    }

    @Override
    public String getPrimaryColumnName(String tableName) throws JuDbException {
        DbMetaData md = new DbMetaData();
        return md.getPrimaryColumnName(tableName);
    }

    @Override
    public List<String> getColumnNames(String tableName) throws JuDbException {
        DbMetaData md = new DbMetaData();
        return Arrays.asList(md.getColumnNames(tableName));
    }

    @Override
    public DbQueryRunner getQueryRunner() {
        return new DbQueryRunnerImpl(this);
    }

    @Override
    public Connection getConnection() {
        return DataSourceUtils.getConnection((DataSource)this.dataSource);
    }

    public String toString() {
        return JuStringUtils.toString((Object)this, (Object[])new Object[]{"name", this.getName()});
    }

    private final class DbQueryRunnerImpl
    implements DbQueryRunner {
        private DbConnectionImpl dbConnection;

        public DbQueryRunnerImpl(DbConnectionImpl dbConnection) {
            this.dbConnection = dbConnection;
        }

        private Connection getConnection() throws JuDbException {
            return this.dbConnection.getConnection();
        }

        @Override
        public DbRowUtils.DbRowsImpl query(String query, Object ... params) throws JuDbException {
            try {
                QueryRunner qr = new QueryRunner();
                return (DbRowUtils.DbRowsImpl)qr.query(this.getConnection(), query, (ResultSetHandler)new DbRowResultSetHandler(), this.processParams(params));
            }
            catch (SQLException ex) {
                throw new JuDbException("Couldn't execute query: " + query, ex);
            }
        }

        @Override
        public int update(String query, Object ... params) throws JuDbException {
            try {
                QueryRunner qr = new QueryRunner();
                return qr.update(this.getConnection(), query, this.processParams(params));
            }
            catch (SQLException ex) {
                throw new JuDbException("Couldn't execute update: " + query, ex);
            }
        }

        @Override
        public DbRow primaryKeyQuery(String tableName, Object primaryKeyValue) throws JuDbException {
            String selectQry = "SELECT * FROM " + tableName + " WHERE " + this.dbConnection.getPrimaryColumnName(tableName) + "=?";
            DbRowUtils.DbRowsImpl dbRows = this.query(selectQry, primaryKeyValue);
            if (dbRows.getRowCount() > 1) {
                throw new JuDbException("PrimaryKeyQuery for " + tableName + " with key=" + primaryKeyValue + ". Expected exactly 1 row, but got " + dbRows.getRowCount());
            }
            return dbRows.getRowCount() == 0 ? null : dbRows.getRow(0);
        }

        @Override
        public DbRow emptyRowQuery(String tableName) throws JuDbException {
            String selectQry = "SELECT * FROM " + tableName + " WHERE 1=0";
            return this.query(selectQry, new Object[0]).getBaseRow();
        }

        @Override
        public DbAction getUpdateAction(String tableName, Object primaryKeyValue) throws JuDbException {
            DbRow row = this.primaryKeyQuery(tableName, primaryKeyValue);
            return row == null ? null : DbActionUtils.newUpdateAction((DbConnection)this.dbConnection, row, tableName).getAction();
        }

        @Override
        public DbAction getInsertAction(String tableName) throws JuDbException {
            return DbActionUtils.newInsertAction(this.dbConnection, tableName).getAction();
        }

        @Override
        public DbAction getDeleteAction(String tableName, Object primaryKeyValue) throws JuDbException {
            return DbActionUtils.newDeleteAction((DbConnection)this.dbConnection, tableName, primaryKeyValue);
        }

        private Object[] processParams(Object[] params) {
            Object[] newParams = Arrays.copyOf(params, params.length);
            for (int i = 0; i < newParams.length; ++i) {
                Object param = newParams[i];
                if (param == null || param.getClass() != java.util.Date.class) continue;
                newParams[i] = new Date(((java.util.Date)param).getTime());
            }
            return newParams;
        }
    }

    private class DbMetaData {
        private DatabaseMetaData metaData;
        private ResultSet rs;

        public DbMetaData() throws JuDbException {
            try {
                this.metaData = DbConnectionImpl.this.getConnection().getMetaData();
            }
            catch (SQLException ex) {
                throw new JuDbException("Couldn't access DatabaseMetaData", ex);
            }
        }

        public List<String> getTableNames() throws JuDbException {
            try {
                this.rs = this.metaData.getTables(DbConnectionImpl.this.getSchemaName(), null, null, new String[]{"TABLE"});
                ArrayList<String> tableNames = new ArrayList<String>();
                while (this.rs.next()) {
                    String tableName = this.rs.getString("TABLE_NAME");
                    tableNames.add(tableName.toUpperCase());
                }
                Collections.sort(tableNames);
                ArrayList<String> arrayList = tableNames;
                return arrayList;
            }
            catch (JuDbException ex) {
                throw ex;
            }
            catch (SQLException ex) {
                throw new JuDbException("Couldn't evaluate table names", ex);
            }
            finally {
                JuDbUtils.closeQuietly(this.rs);
                this.rs = null;
            }
        }

        public String getPrimaryColumnName(String tableName) throws JuDbException {
            try {
                this.rs = this.metaData.getPrimaryKeys(null, null, tableName.toUpperCase());
                String columnName = null;
                if (!this.rs.next()) {
                    throw new JuDbException("Couldn't evaluate primary key for table " + tableName);
                }
                columnName = this.rs.getString("COLUMN_NAME");
                if (this.rs.next()) {
                    throw new JuDbException("Driver returned multiple primary keys for table " + tableName);
                }
                String string = columnName.toUpperCase();
                return string;
            }
            catch (JuDbException ex) {
                throw ex;
            }
            catch (SQLException ex) {
                throw new JuDbException("Couldn't evaluate primary key for table " + tableName, ex);
            }
            finally {
                JuDbUtils.closeQuietly(this.rs);
                this.rs = null;
            }
        }

        public String[] getColumnNames(String tableName) throws JuDbException {
            try {
                this.rs = this.metaData.getColumns(null, null, tableName.toUpperCase(), null);
                ArrayList<String> columnNames = new ArrayList<String>();
                while (this.rs.next()) {
                    String columnName = this.rs.getString("COLUMN_NAME");
                    columnNames.add(columnName.toUpperCase());
                }
                if (columnNames.size() == 0) {
                    throw new JuDbException("Couldn't evaluate column names for table " + tableName + ": Driver returned empty ResultSet.");
                }
                String[] stringArray = columnNames.toArray(new String[0]);
                return stringArray;
            }
            catch (JuDbException ex) {
                throw ex;
            }
            catch (SQLException ex) {
                throw new JuDbException("Couldn't evaluate primary key for table " + tableName, ex);
            }
            finally {
                JuDbUtils.closeQuietly(this.rs);
                this.rs = null;
            }
        }
    }
}

