/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.db;

import ch.inftec.ju.db.DatabaseMetaDataCallback;
import ch.inftec.ju.db.DbSpecificHandlerDerby;
import ch.inftec.ju.db.DbSpecificHandlerH2;
import ch.inftec.ju.db.DbSpecificHandlerMySql;
import ch.inftec.ju.db.DbSpecificHandlerOracle;
import ch.inftec.ju.db.DbWork;
import ch.inftec.ju.db.DsWork;
import ch.inftec.ju.db.JuDbException;
import java.util.List;

public interface JuConnUtil {
    public DbType getDbType();

    public void doWork(DbWork var1);

    public void doWork(DsWork var1);

    public MetaDataInfo getMetaDataInfo();

    public DbHandler getDbHandler();

    public <T> T extractDatabaseMetaData(DatabaseMetaDataCallback<T> var1);

    public static enum DbType {
        DERBY{

            @Override
            protected DbHandler getDbSpecificHandler(JuConnUtil connUtil) {
                return new DbSpecificHandlerDerby(connUtil);
            }
        }
        ,
        H2{

            @Override
            protected DbHandler getDbSpecificHandler(JuConnUtil connUtil) {
                return new DbSpecificHandlerH2(connUtil);
            }
        }
        ,
        MYSQL{

            @Override
            protected DbHandler getDbSpecificHandler(JuConnUtil connUtil) {
                return new DbSpecificHandlerMySql(connUtil);
            }
        }
        ,
        ORACLE{

            @Override
            protected DbHandler getDbSpecificHandler(JuConnUtil connUtil) {
                return new DbSpecificHandlerOracle(connUtil);
            }
        };


        static DbType evaluateDbType(String productName) {
            if (productName.toLowerCase().contains("derby")) {
                return DERBY;
            }
            if (productName.toLowerCase().contains("h2")) {
                return H2;
            }
            if (productName.toLowerCase().contains("mysql")) {
                return MYSQL;
            }
            if (productName.toLowerCase().contains("oracle")) {
                return ORACLE;
            }
            throw new JuDbException("Unknown DB. Product name: " + productName);
        }

        protected abstract DbHandler getDbSpecificHandler(JuConnUtil var1);
    }

    public static interface DbHandler {
        public String convertTableNameCasing(String var1);

        public List<String> getSequenceNames();

        public Long getNextValueFromSequence(String var1);

        public void resetIdentityGenerationOrSequences(int var1);
    }

    public static interface MetaDataInfo {
        public String getUserName();

        public String getUrl();

        public List<String> getPrimaryKeyColumns(String var1);

        public List<String> getTableNames();
    }
}

