/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.db;

import ch.inftec.ju.db.DbSpecificHandlerDefault;
import ch.inftec.ju.db.DbWork;
import ch.inftec.ju.db.JuConnUtil;
import ch.inftec.ju.db.JuConnUtils;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import org.springframework.jdbc.core.JdbcTemplate;

public class DbSpecificHandlerMySql
extends DbSpecificHandlerDefault {
    public DbSpecificHandlerMySql(JuConnUtil connUtil) {
        super(connUtil);
    }

    @Override
    public String convertTableNameCasing(String tableName) {
        for (String actualTableName : this.connUtil.getMetaDataInfo().getTableNames()) {
            if (!actualTableName.equalsIgnoreCase(tableName)) continue;
            return actualTableName;
        }
        return tableName;
    }

    @Override
    public void resetIdentityGenerationOrSequences(final int val) {
        this.connUtil.doWork(new DbWork(){

            @Override
            public void execute(Connection conn) {
                JdbcTemplate jt = JuConnUtils.asJdbcTemplate(conn);
                List res = jt.queryForList("select c.TABLE_NAME, c.COLUMN_NAME from information_schema.columns c where c.EXTRA='auto_increment'");
                for (Map row : res) {
                    String tableName = row.get("TABLE_NAME").toString();
                    String columnName = row.get("COLUMN_NAME").toString();
                    DbSpecificHandlerMySql.this.logger.debug(String.format("Restarting ID column %s.%s with %d", tableName, columnName, val));
                    jt.execute(String.format("alter table %s auto_increment = %d", tableName, val));
                }
            }
        });
    }
}

