/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.db;

import ch.inftec.ju.db.DbSpecificHandler;
import ch.inftec.ju.db.DbWork;
import ch.inftec.ju.db.JuConnUtil;
import ch.inftec.ju.db.JuConnUtils;
import ch.inftec.ju.db.JuDbException;
import ch.inftec.ju.util.DataHolder;
import java.sql.Connection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public abstract class DbSpecificHandlerDefault
implements DbSpecificHandler,
JuConnUtil.DbHandler {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final JuConnUtil connUtil;

    protected DbSpecificHandlerDefault(JuConnUtil connUtil) {
        this.connUtil = connUtil;
    }

    protected <T> List<T> queryForList(final String sql, final Class<T> listType) {
        final DataHolder res = new DataHolder();
        this.connUtil.doWork(new DbWork(){

            @Override
            public void execute(Connection conn) {
                JdbcTemplate jt = JuConnUtils.asJdbcTemplate(conn);
                res.setValue((Object)jt.queryForList(sql, listType));
            }
        });
        return (List)res.getValue();
    }

    protected <T> T queryForObject(final String sql, final Class<T> requiredType) {
        final DataHolder res = new DataHolder();
        this.connUtil.doWork(new DbWork(){

            @Override
            public void execute(Connection conn) {
                JdbcTemplate jt = JuConnUtils.asJdbcTemplate(conn);
                res.setValue(jt.queryForObject(sql, requiredType));
            }
        });
        return (T)res.getValue();
    }

    @Override
    public String convertTableNameCasing(String tableName) {
        return tableName.toUpperCase();
    }

    @Override
    public List<String> getSequenceNames() {
        throw new JuDbException("Sequences not supported by " + (Object)((Object)this.connUtil.getDbType()));
    }

    @Override
    public Long getNextValueFromSequence(String sequenceName) {
        throw new JuDbException("Sequences not supported by " + (Object)((Object)this.connUtil.getDbType()));
    }
}

