/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.db;

import bitronix.tm.resource.jdbc.PoolingDataSource;
import ch.inftec.ju.db.ConnectionInfo;
import ch.inftec.ju.util.AssertUtil;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionInfoPoolingDataSource
extends PoolingDataSource {
    private Logger logger = LoggerFactory.getLogger(ConnectionInfoPoolingDataSource.class);

    public void setConnectionInfo(ConnectionInfo connectionInfo) {
        Properties props = new Properties();
        if (StringUtils.isEmpty((CharSequence)this.getClassName())) {
            String className = null;
            if (connectionInfo.getConnectionString().startsWith("jdbc:derby:")) {
                className = "org.apache.derby.jdbc.EmbeddedXADataSource";
            } else if (connectionInfo.getConnectionString().startsWith("jdbc:h2:")) {
                className = "org.h2.jdbcx.JdbcDataSource";
            } else if (connectionInfo.getConnectionString().startsWith("jdbc:mysql:")) {
                className = "com.mysql.jdbc.jdbc2.optional.MysqlXADataSource";
            } else if (connectionInfo.getConnectionString().startsWith("jdbc:oracle:")) {
                className = "oracle.jdbc.xa.client.OracleXADataSource";
            }
            if (className != null) {
                this.logger.debug("Evaluated XA DataSource className: {}", (Object)className);
                this.setClassName(className);
            }
        }
        AssertUtil.assertNotNull((String)"ClassName attribute cannot be evaluated and must be set explicitly", (Object)this.getClassName());
        if (this.getClassName().startsWith("org.apache.derby.")) {
            String dbName = connectionInfo.getConnectionString();
            if (dbName.startsWith("jdbc:derby:")) {
                dbName = dbName.substring("jdbc:derby:".length());
            }
            props.put("databaseName", dbName);
        } else {
            props.put("URL", connectionInfo.getConnectionString());
        }
        if (StringUtils.isNotEmpty((CharSequence)connectionInfo.getUserName())) {
            props.put("user", connectionInfo.getUserName());
        }
        if (StringUtils.isNotEmpty((CharSequence)connectionInfo.getPassword())) {
            props.put("password", connectionInfo.getPassword());
        }
        this.setDriverProperties(props);
        this.setUniqueName(connectionInfo.getName());
    }
}

