package ch.inftec.ju.db;

import java.sql.Connection;
import java.util.List;

import org.springframework.jdbc.core.JdbcTemplate;

import ch.inftec.ju.util.ConversionUtils;

/**
 * DbSpecificHandler implementations for H2.
 * @author Martin
 *
 */
public class DbSpecificHandlerOracle extends DbSpecificHandlerDefault {
	public DbSpecificHandlerOracle(JuConnUtil connUtil) {
		super(connUtil);
	}
	
	@Override
	public List<String> getSequenceNames() {
		return this.queryForList("select SEQUENCE_NAME from USER_SEQUENCES", String.class);
	}
	
	@Override
	public void resetIdentityGenerationOrSequences(final int val) {
		this.connUtil.doWork(new DbWork() {
			@Override
			public void execute(Connection conn) {
				JdbcTemplate jt = JuConnUtils.asJdbcTemplate(conn);
				
				for (String sequence : getSequenceNames()) {
				// We'll just drop and recreate the sequence.
					jt.execute("drop sequence " + sequence);
					jt.execute(String.format("create sequence %s start with %d", sequence, val));
				}
			}
		});
	}
	
	@Override
	public Long getNextValueFromSequence(String sequenceName) {
		// We'll probably get a BigDecimal
		return ConversionUtils.toLong(this.queryForObject(String.format("select %s.nextVal from dual", sequenceName), Object.class));
	}
}
