package ch.inftec.ju.db;

import java.sql.Connection;
import java.util.List;
import java.util.Map;

import org.springframework.jdbc.core.JdbcTemplate;

/**
 * DbSpecificHandler implementations for MySQL.
 * @author Martin
 *
 */
public class DbSpecificHandlerMySql extends DbSpecificHandlerDefault {
	public DbSpecificHandlerMySql(JuConnUtil connUtil) {
		super(connUtil);
	}
	
	@Override
	public String convertTableNameCasing(String tableName) {
		// MySQL is case sensitive, so look for the exact casing in the table list
		for (String actualTableName : this.connUtil.getMetaDataInfo().getTableNames()) {
			if (actualTableName.equalsIgnoreCase(tableName)) return actualTableName;
		}
		
		// If we were unlucky, just return the same tableName
		return tableName;
	}
	
	@Override
	public void resetIdentityGenerationOrSequences(final int val) {
		this.connUtil.doWork(new DbWork() {
			@Override
			public void execute(Connection conn) {
				JdbcTemplate jt = JuConnUtils.asJdbcTemplate(conn);
				
				// Reset autoincrement values
				List<Map<String, Object>> res = jt.queryForList("select c.TABLE_NAME, c.COLUMN_NAME " +
					"from information_schema.columns c " +
					"where c.EXTRA='auto_increment'"); //c.TABLE_NAME='Player'" 
								
				for (Map<String, Object> row : res) {
					String tableName = row.get("TABLE_NAME").toString();
					String columnName = row.get("COLUMN_NAME").toString();
					
					logger.debug(String.format("Restarting ID column %s.%s with %d", tableName, columnName, val));
					
					jt.execute(String.format("alter table %s auto_increment = %d"
							, tableName
							, val));
				}
			}
		});
	}
}
