/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util.change;

import ch.inftec.ju.db.DbConnection;
import ch.inftec.ju.db.DbRow;
import ch.inftec.ju.util.JuStringUtils;
import ch.inftec.ju.util.XString;
import ch.inftec.ju.util.change.ChangeItem;
import ch.inftec.ju.util.change.DbAction;
import ch.inftec.ju.util.change.DbActionValue;
import ch.inftec.ju.util.change.DbChangeUtils;
import ch.inftec.ju.util.general.Descriptor;
import ch.inftec.ju.util.general.DescriptorUtils;
import ch.inftec.ju.util.persistable.GenericMemento;
import ch.inftec.ju.util.persistable.GenericMementoUtils;
import ch.inftec.ju.util.persistable.Persistable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;

abstract class AbstractDbRowDbAction
implements DbAction {
    private final DbConnection dbConnection;
    private final DbRow row;
    private final String tableName;
    private final HashMap<String, Object> changedValues = new HashMap();

    protected AbstractDbRowDbAction(DbConnection dbConnection, DbRow row, String tableName) {
        this.dbConnection = dbConnection;
        this.row = row;
        this.tableName = tableName.toUpperCase();
    }

    protected abstract void execute();

    public final Descriptor getDescriptor() {
        return DescriptorUtils.newInstance((String)String.format("%s(%s.%s)", DbChangeUtils.TYPE_HANDLER.getTypeName((Persistable)this), this.getTableName(), this.getPrimaryKeyValue()));
    }

    public final List<ChangeItem> getChildItems() {
        return Collections.emptyList();
    }

    public final ChangeItem.ChangeItemHandler getHandler() {
        return new ChangeItem.ChangeItemHandler(){

            public ChangeItem createUndoItem() {
                return AbstractDbRowDbAction.this.createUndoAction();
            }

            public void execute() {
                AbstractDbRowDbAction.this.execute();
            }

            public String toString() {
                return JuStringUtils.toString((Object)this, (Object[])new Object[]{"action", AbstractDbRowDbAction.this});
            }
        };
    }

    protected final DbConnection getDbConnection() {
        return this.dbConnection;
    }

    protected final DbRow getRow() {
        return this.row;
    }

    protected final String getTableName() {
        return this.tableName;
    }

    @Override
    public final DbAction setValue(String columnName, Object value) {
        this.changedValues.put(columnName.toUpperCase(), value);
        return this;
    }

    @Override
    public final Val getVal(String columnName) {
        return new Val(columnName);
    }

    protected final Val getPrimaryKeyValue() {
        return this.getVal(this.getDbConnection().getPrimaryColumnName(this.getTableName()));
    }

    protected final Val[] getChangedColumns() {
        ArrayList<Val> changedVals = new ArrayList<Val>();
        for (int i = 0; i < this.getRow().getColumnCount(); ++i) {
            Val val = this.getVal(this.getRow().getColumnName(i));
            if (!val.hasChanged()) continue;
            changedVals.add(val);
        }
        return changedVals.toArray(new Val[0]);
    }

    public final GenericMemento createMemento() {
        GenericMementoUtils.GenericMementoBuilder builder = GenericMementoUtils.builder();
        builder.add(".connectionName", (Object)this.dbConnection.getName()).add(".table", (Object)this.getTableName()).add(".id", this.getPrimaryKeyValue().getValuePrioOriginal());
        for (Val val : this.getChangedColumns()) {
            builder.add(val.getColumnName() + ".orig", val.getOriginalValue());
            builder.add(val.getColumnName() + ".new", val.getChangedValue());
        }
        return builder.build();
    }

    public final void setMemento(GenericMemento memento) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public final String toString() {
        return JuStringUtils.toString((Object)this, (Object[])new Object[]{"tableName", this.tableName, "primaryKeyValue", this.getPrimaryKeyValue(), "dbConnection", this.dbConnection});
    }

    class Val
    implements DbActionValue {
        private String columnName;

        private Val(String columnName) {
            this.columnName = columnName;
        }

        @Override
        public String getColumnName() {
            return this.columnName;
        }

        @Override
        public Object getOriginalValue() {
            return AbstractDbRowDbAction.this.getRow().getValue(this.getColumnName());
        }

        @Override
        public Object getChangedValue() {
            return AbstractDbRowDbAction.this.changedValues.get(this.getColumnName());
        }

        @Override
        public Object getValue() {
            if (AbstractDbRowDbAction.this.changedValues.containsKey(this.getColumnName())) {
                return this.getChangedValue();
            }
            return this.getOriginalValue();
        }

        private Object getValuePrioOriginal() {
            if (AbstractDbRowDbAction.this.getRow().getValue(this.getColumnName()) != null) {
                return this.getOriginalValue();
            }
            return this.getChangedValue();
        }

        @Override
        public boolean hasChanged() {
            return AbstractDbRowDbAction.this.changedValues.containsKey(this.getColumnName()) && ObjectUtils.notEqual((Object)this.getOriginalValue(), (Object)this.getChangedValue());
        }

        public String toString() {
            XString val = new XString();
            val.addFormatted("%s(%s", new Object[]{this.getColumnName(), this.getOriginalValue()});
            if (this.hasChanged()) {
                val.addText(new Object[]{">", this.getChangedValue()});
            }
            val.addText(")");
            return val.toString();
        }
    }
}

