/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.db;

import ch.inftec.ju.db.DbRow;
import ch.inftec.ju.db.DbRows;
import ch.inftec.ju.util.JuCollectionUtils;
import ch.inftec.ju.util.JuStringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public final class DbRowUtils {
    public static DbRowBuilder newDbRow() {
        return new DbRowBuilder();
    }

    static class DbRowsImpl
    implements DbRows {
        private DbRow baseRow;
        private ArrayList<DbRow> rows = new ArrayList();
        private Integer hashCode = null;

        DbRowsImpl() {
        }

        void addRow(DbRow row) {
            this.rows.add(row);
            if (this.baseRow == null) {
                this.baseRow = row;
            }
            this.hashCode = null;
        }

        void setBaseRow(DbRow row) {
            this.baseRow = row;
            this.hashCode = null;
        }

        DbRow getBaseRow() {
            return this.baseRow;
        }

        @Override
        public int getColumnCount() {
            return this.baseRow.getColumnCount();
        }

        @Override
        public String getColumnName(int index) {
            return this.baseRow.getColumnName(index);
        }

        @Override
        public int getColumnType(int index) {
            return this.baseRow.getColumnType(index);
        }

        public String toString() {
            return JuStringUtils.toString((Object)this, (Object[])new Object[]{"rowsCount", this.rows.size(), "baseRow", this.baseRow});
        }

        public int hashCode() {
            if (this.hashCode == null) {
                HashCodeBuilder h = new HashCodeBuilder();
                for (int i = 0; i < this.getColumnCount(); ++i) {
                    h.append((Object)this.getColumnName(i));
                    h.append(this.getColumnType(i));
                }
                for (DbRow row : this) {
                    h.append((Object)row);
                }
                this.hashCode = h.toHashCode();
            }
            return this.hashCode;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !(obj instanceof DbRowsImpl)) {
                return false;
            }
            DbRowsImpl rows = (DbRowsImpl)obj;
            return ObjectUtils.equals((Object)this.baseRow, (Object)rows.baseRow) && this.hashCode() == rows.hashCode() && JuCollectionUtils.collectionEquals(this.rows, rows.rows);
        }

        @Override
        public int getRowCount() {
            return this.rows.size();
        }

        @Override
        public DbRow getRow(int i) {
            return this.rows.get(i);
        }

        @Override
        public Iterator<DbRow> iterator() {
            return this.rows.iterator();
        }
    }

    private static class DbRowImpl
    implements DbRow {
        private ArrayList<String> columnNames = new ArrayList();
        private ArrayList<Integer> columnTypes = new ArrayList();
        private HashMap<String, Object> values = new HashMap();
        private Integer hashCode = null;

        private DbRowImpl() {
        }

        void addValue(String columnName, int columnType, Object value) {
            if (this.values.containsKey(columnName = columnName.toUpperCase())) {
                throw new IllegalArgumentException("Duplicate column name: " + columnName);
            }
            this.columnNames.add(columnName);
            this.columnTypes.add(columnType);
            this.values.put(columnName, value);
            this.hashCode = null;
        }

        @Override
        public Object getValue(String columnName) {
            if (columnName == null) {
                return null;
            }
            return this.values.get(columnName.toUpperCase());
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.size();
        }

        @Override
        public String getColumnName(int index) {
            return this.columnNames.get(index);
        }

        @Override
        public int getColumnType(int index) {
            return this.columnTypes.get(index);
        }

        public String toString() {
            return JuStringUtils.toString((Object)this, (Object[])new Object[]{"values", this.values});
        }

        public int hashCode() {
            if (this.hashCode == null) {
                HashCodeBuilder h = new HashCodeBuilder();
                for (int i = 0; i < this.getColumnCount(); ++i) {
                    h.append((Object)this.getColumnName(i));
                    h.append(this.getColumnType(i));
                    h.append(this.getValue(this.getColumnName(i)));
                }
                this.hashCode = h.toHashCode();
            }
            return this.hashCode;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !(obj instanceof DbRowImpl)) {
                return false;
            }
            DbRowImpl row = (DbRowImpl)obj;
            if (this.getColumnCount() == row.getColumnCount() && this.hashCode() == row.hashCode() && JuCollectionUtils.mapEquals(this.values, row.values)) {
                return JuCollectionUtils.collectionEquals(this.columnTypes, row.columnTypes) && JuCollectionUtils.collectionEquals(this.columnNames, row.columnNames) && JuCollectionUtils.mapEquals(this.values, row.values);
            }
            return false;
        }
    }

    public static final class DbRowBuilder {
        private DbRowImpl dbRow = new DbRowImpl();

        public DbRowBuilder addValue(String columnName, int columnType, Object value) {
            this.dbRow.addValue(columnName, columnType, value);
            return this;
        }

        public DbRow getRow() {
            return this.dbRow;
        }
    }
}

