/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util.change;

import ch.inftec.ju.db.DbConnection;
import ch.inftec.ju.db.DbRow;
import ch.inftec.ju.db.DbRowUtils;
import ch.inftec.ju.db.JuDbException;
import ch.inftec.ju.util.JuRuntimeException;
import ch.inftec.ju.util.XString;
import ch.inftec.ju.util.change.AbstractDbRowDbAction;
import ch.inftec.ju.util.change.DbAction;
import ch.inftec.ju.util.change.DeleteDbRowDbAction;
import java.util.ArrayList;

class InsertDbRowDbAction
extends AbstractDbRowDbAction {
    private static final String MEMENTO_TYPE_NAME = "Insert";

    InsertDbRowDbAction(DbConnection dbConn, DbRow row, String tableName) {
        super(dbConn, row, tableName);
    }

    @Override
    public void execute() {
        XString insertQry = null;
        try {
            insertQry = new XString("INSERT INTO " + this.getTableName() + " (");
            ArrayList<Object> values = new ArrayList<Object>();
            XString valuesQry = new XString("VALUES (");
            for (int i = 0; i < this.getRow().getColumnCount(); ++i) {
                String columnName = this.getRow().getColumnName(i);
                insertQry.assertText(new String[]{"(", ", "});
                insertQry.addText(columnName);
                valuesQry.assertText(new String[]{"(", ", "});
                valuesQry.addText("?");
                values.add(this.getVal(columnName).getValue());
            }
            insertQry.addText(") ");
            insertQry.addText(new Object[]{valuesQry});
            insertQry.addText(")");
            int res = this.getDbConnection().getQueryRunner().update(insertQry.toString(), values.toArray(new Object[0]));
            if (res != 1) {
                throw new JuDbException("Execution of query returned " + res + ", expected 1: " + insertQry);
            }
        }
        catch (Exception ex) {
            throw new JuRuntimeException("Failed to execute insert: " + insertQry, (Throwable)ex);
        }
    }

    @Override
    public DbAction createUndoAction() {
        DbRowUtils.DbRowBuilder targetRowBuilder = DbRowUtils.newDbRow();
        for (int i = 0; i < this.getRow().getColumnCount(); ++i) {
            String columnName = this.getRow().getColumnName(i);
            targetRowBuilder.addValue(columnName, this.getRow().getColumnType(i), this.getVal(columnName).getValue());
        }
        DeleteDbRowDbAction undoAction = new DeleteDbRowDbAction(this.getDbConnection(), targetRowBuilder.getRow(), this.getTableName());
        return undoAction;
    }
}

