/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.db.auth;

import ch.inftec.ju.db.auth.AuthenticationEditorModel;
import ch.inftec.ju.db.auth.UnknownUserHandler;
import ch.inftec.ju.db.auth.entity.AuthRole;
import ch.inftec.ju.db.auth.entity.AuthUser;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class JuUserDetailsService
implements UserDetailsService {
    @Autowired(required=false)
    private UnknownUserHandler unknownUserHandler;
    @Autowired
    private AuthenticationEditorModel authenticationEditorModel;

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        AuthUser authUser = this.authenticationEditorModel.getUser(username);
        if (authUser == null) {
            UnknownUserHandler.NewUserInfo newUserInfo;
            if (this.unknownUserHandler != null && (newUserInfo = this.unknownUserHandler.handleUser(username)) != null) {
                authUser = this.authenticationEditorModel.addUser(username, newUserInfo.getPassword(), newUserInfo.getAuthorities());
            }
            if (authUser == null) {
                throw new UsernameNotFoundException("No such user: " + username);
            }
        } else {
            this.authenticationEditorModel.updateLoginCount(authUser);
        }
        ArrayList<SimpleGrantedAuthority> grantedAuths = new ArrayList<SimpleGrantedAuthority>();
        for (AuthRole authRole : authUser.getRoles()) {
            grantedAuths.add(new SimpleGrantedAuthority(authRole.getName()));
        }
        User user = new User(username, authUser.getPassword(), grantedAuths);
        return user;
    }
}

