/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.db.auth;

import ch.inftec.ju.db.JuDbUtils;
import ch.inftec.ju.db.auth.entity.AuthRole;
import ch.inftec.ju.db.auth.entity.AuthUser;
import ch.inftec.ju.db.auth.repo.AuthRoleRepo;
import ch.inftec.ju.db.auth.repo.AuthUserRepo;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

public class AuthDao {
    @PersistenceContext(unitName="juAuth")
    private EntityManager em;

    public void addRole(AuthUser user, String roleName) {
        AuthRoleRepo roleRepo = JuDbUtils.getJpaRepository(this.em, AuthRoleRepo.class);
        AuthUserRepo userRepo = JuDbUtils.getJpaRepository(this.em, AuthUserRepo.class);
        AuthRole role = roleRepo.getByName(roleName);
        if (role == null) {
            role = new AuthRole();
            role.setName(roleName);
            this.em.persist((Object)role);
        }
        if (roleRepo.getByNameAndUsersId(roleName, user.getId()) == null) {
            user.getRoles().add(role);
            role.getUsers().add(user);
            userRepo.save(user);
            roleRepo.save(role);
        }
    }

    public void removeRole(AuthUser user, String roleName) {
        AuthRoleRepo roleRepo = JuDbUtils.getJpaRepository(this.em, AuthRoleRepo.class);
        AuthUserRepo userRepo = JuDbUtils.getJpaRepository(this.em, AuthUserRepo.class);
        AuthRole role = roleRepo.getByName(roleName);
        if (role != null && roleRepo.getByNameAndUsersId(roleName, user.getId()) != null) {
            role.getUsers().remove(user);
            user.getRoles().remove(role);
            roleRepo.save(role);
            userRepo.save(user);
        }
    }
}

