/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.db;

import ch.inftec.ju.db.DbSpecificHandlerDefault;
import ch.inftec.ju.db.JuEmUtil;
import ch.inftec.ju.util.ConversionUtils;
import java.util.List;
import javax.persistence.EntityManager;

public class DbSpecificHandlerH2
extends DbSpecificHandlerDefault {
    public DbSpecificHandlerH2(JuEmUtil emUtil, EntityManager em) {
        super(emUtil, em);
    }

    @Override
    public List<String> getSequenceNames() {
        List results = this.em.createNativeQuery("select SEQUENCE_NAME name from INFORMATION_SCHEMA.SEQUENCES").getResultList();
        return results;
    }

    @Override
    public void resetIdentityGenerationOrSequences(int val) {
        for (String sequenceName : this.getSequenceNames()) {
            this.logger.debug(String.format("Restarting sequence %s with %d", sequenceName, val));
            this.em.createNativeQuery(String.format("alter sequence %s restart with %d increment by %d", sequenceName, val, 1)).executeUpdate();
        }
    }

    @Override
    public Long getNextValueFromSequence(String sequenceName) {
        return ConversionUtils.toLong((Object)this.em.createNativeQuery(String.format("select NEXTVAL('%s')", sequenceName)).getSingleResult());
    }
}

