/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.util.change;

import ch.inftec.ju.db.DbConnection;
import ch.inftec.ju.util.JuBeanUtils;
import ch.inftec.ju.util.JuStringUtils;
import ch.inftec.ju.util.change.ChangeItem;
import ch.inftec.ju.util.change.DbAction;
import ch.inftec.ju.util.change.DbActionUtils;
import ch.inftec.ju.util.change.DeleteDbRowDbAction;
import ch.inftec.ju.util.change.InsertDbRowDbAction;
import ch.inftec.ju.util.change.PersistableChangeItem;
import ch.inftec.ju.util.change.UpdateDbRowDbAction;
import ch.inftec.ju.util.general.Descriptor;
import ch.inftec.ju.util.general.DescriptorUtils;
import ch.inftec.ju.util.persistable.GenericMemento;
import ch.inftec.ju.util.persistable.GenericMementoUtils;
import ch.inftec.ju.util.persistable.Persistable;
import ch.inftec.ju.util.persistable.TypeHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DbChangeUtils {
    private static final String UNDO_SUFFIX = ".undo";
    static final TypeHandler TYPE_HANDLER = GenericMementoUtils.newTypeHandler().addMapping(DeleteDbRowDbAction.class).addMapping(InsertDbRowDbAction.class).addMapping(UpdateDbRowDbAction.class).getHandler();

    public static DbChangeSetBuilder buildChangeSet(DbConnection dbConn) {
        return new DbChangeSetBuilder(dbConn);
    }

    private static final class DbChangeGroup
    implements ChangeItem {
        private Descriptor descriptor;
        private List<DbAction> actions = new ArrayList<DbAction>();

        private DbChangeGroup(String name, String description) {
            this.descriptor = DescriptorUtils.newInstance((String)name, (String)description);
        }

        public Descriptor getDescriptor() {
            return this.descriptor;
        }

        public List<ChangeItem> getChildItems() {
            return Collections.unmodifiableList(new ArrayList<DbAction>(this.actions));
        }

        public ChangeItem.ChangeItemHandler getHandler() {
            return null;
        }

        public String toString() {
            return JuStringUtils.toString((Object)this, (Object[])new Object[]{"descriptor", this.getDescriptor(), "actionCount", this.actions.size()});
        }
    }

    private static class DbChangeSet
    implements PersistableChangeItem {
        private final DbConnection dbConn;
        private final Descriptor descriptor;
        private List<DbChangeGroup> groups = new ArrayList<DbChangeGroup>();

        private DbChangeSet(DbConnection dbConn, String name, String description) {
            this.dbConn = dbConn;
            this.descriptor = DescriptorUtils.newInstance((String)name, (String)description);
        }

        public Descriptor getDescriptor() {
            return this.descriptor;
        }

        public List<ChangeItem> getChildItems() {
            return Collections.unmodifiableList(new ArrayList<DbChangeGroup>(this.groups));
        }

        public ChangeItem.ChangeItemHandler getHandler() {
            return new DbChangeSetHandler(this);
        }

        public String toString() {
            return JuStringUtils.toString((Object)this, (Object[])new Object[]{"descriptor", this.getDescriptor(), "groupCount", this.groups.size()});
        }

        public GenericMemento createMemento() {
            GenericMementoUtils.GenericMementoBuilder setBuilder = GenericMementoUtils.builder().add(".connectionName", (Object)this.dbConn.getName());
            for (DbChangeGroup group : this.groups) {
                GenericMementoUtils.GenericMementoBuilder groupBuilder = setBuilder.newChild().add("groupName", (Object)group.getDescriptor().getName()).add("groupDescription", (Object)group.getDescriptor().getDescription());
                for (DbAction action : group.actions) {
                    groupBuilder.newChild().add("@type", (Object)TYPE_HANDLER.getTypeName((Persistable)action)).add(action.createMemento()).childDone();
                }
                groupBuilder.childDone();
            }
            return setBuilder.build();
        }

        public void setMemento(GenericMemento memento) {
            throw new UnsupportedOperationException("Not yet implemented");
        }

        private static final class DbChangeSetHandler
        implements ChangeItem.ChangeItemHandler {
            private final DbChangeSet set;

            private DbChangeSetHandler(DbChangeSet set) {
                this.set = set;
            }

            public ChangeItem createUndoItem() {
                DbChangeSetBuilder setBuilder = DbChangeUtils.buildChangeSet(this.set.dbConn).name(this.set.getDescriptor().getName() + DbChangeUtils.UNDO_SUFFIX).description(this.set.getDescriptor().getDescription() + DbChangeUtils.UNDO_SUFFIX);
                for (int i = this.set.groups.size() - 1; i >= 0; --i) {
                    DbChangeGroup group = (DbChangeGroup)this.set.groups.get(i);
                    DbChangeGroupBuilder groupBuilder = setBuilder.newGroup(group.getDescriptor().getName(), group.getDescriptor().getDescription());
                    for (int j = group.actions.size() - 1; j >= 0; --j) {
                        DbAction action = (DbAction)group.actions.get(j);
                        groupBuilder.addAction(action.createUndoAction());
                    }
                    groupBuilder.endGroup();
                }
                return setBuilder.build();
            }

            public void execute() {
                for (DbChangeGroup group : this.set.groups) {
                    for (DbAction action : group.actions) {
                        action.getHandler().execute();
                    }
                }
            }
        }
    }

    public static class DbChangeGroupActionBuilder {
        private final DbChangeGroupBuilder groupBuilder;
        private final DbActionUtils.AbstractActionBuilder actionBuilder;

        private DbChangeGroupActionBuilder(DbChangeGroupBuilder groupBuilder, DbActionUtils.AbstractActionBuilder actionBuilder) {
            this.groupBuilder = groupBuilder;
            this.actionBuilder = actionBuilder;
        }

        public DbChangeGroupActionBuilder setValue(String columnName, Object value) {
            this.actionBuilder.setValue(columnName, value);
            return this;
        }

        public DbChangeGroupBuilder endAction() {
            this.groupBuilder.addAction(this.actionBuilder.getAction());
            return this.groupBuilder;
        }
    }

    public static class DbChangeGroupBuilder {
        private final DbChangeSetBuilder parentBuilder;
        private final DbChangeGroup group;

        private DbChangeGroupBuilder(DbChangeSetBuilder parentBuilder, String name, String description) {
            this.parentBuilder = parentBuilder;
            this.group = new DbChangeGroup(name, description);
        }

        public DbChangeGroupBuilder addAction(DbAction action) {
            this.group.actions.add(action);
            return this;
        }

        public DbChangeGroupActionBuilder newUpdateAction(String tableName, Object primaryKeyValue) {
            DbActionUtils.AbstractActionBuilder actionBuilder = DbActionUtils.newUpdateAction(this.parentBuilder.dbConn, tableName, primaryKeyValue);
            return new DbChangeGroupActionBuilder(this, actionBuilder);
        }

        public DbChangeGroupActionBuilder newInsertAction(String tableName) {
            DbActionUtils.AbstractActionBuilder actionBuilder = DbActionUtils.newInsertAction(this.parentBuilder.dbConn, tableName);
            return new DbChangeGroupActionBuilder(this, actionBuilder);
        }

        public DbChangeGroupBuilder newDeleteAction(String tableName, Object primaryKeyValue) {
            this.addAction(DbActionUtils.newDeleteAction(this.parentBuilder.dbConn, tableName, primaryKeyValue));
            return this;
        }

        public DbChangeSetBuilder endGroup() {
            return this.parentBuilder;
        }
    }

    public static class DbChangeSetBuilder {
        private final DbConnection dbConn;
        private String name;
        private String description;
        private List<DbChangeGroupBuilder> groupBuilders = new ArrayList<DbChangeGroupBuilder>();

        private DbChangeSetBuilder(DbConnection dbConn) {
            this.dbConn = dbConn;
        }

        public DbChangeSetBuilder name(String name) {
            this.name = name;
            return this;
        }

        public DbChangeSetBuilder description(String description) {
            this.description = description;
            return this;
        }

        public DbChangeGroupBuilder newGroup(String name, String description) {
            DbChangeGroupBuilder groupBuilder = new DbChangeGroupBuilder(this, name, description);
            this.groupBuilders.add(groupBuilder);
            return groupBuilder;
        }

        public PersistableChangeItem build() {
            JuBeanUtils.checkFieldsNotNull((Object)this, (String[])new String[]{"name", "description"});
            DbChangeSet changeSet = new DbChangeSet(this.dbConn, this.name, this.description);
            for (DbChangeGroupBuilder groupBuilder : this.groupBuilders) {
                changeSet.groups.add(groupBuilder.group);
            }
            return changeSet;
        }
    }
}

