/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.db;

import ch.inftec.ju.db.ConnectionInfo;
import ch.inftec.ju.db.EmWork;
import ch.inftec.ju.db.JuDbException;
import ch.inftec.ju.util.AssertUtil;
import ch.inftec.ju.util.IOUtil;
import ch.inftec.ju.util.JuObjectUtils;
import java.io.BufferedReader;
import java.io.Reader;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.metamodel.ManagedType;
import javax.sql.DataSource;
import org.apache.commons.dbutils.DbUtils;
import org.hibernate.Session;
import org.hibernate.cfg.Configuration;
import org.hibernate.jdbc.Work;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.repository.support.JpaRepositoryFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.DatabaseMetaDataCallback;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.MetaDataAccessException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Deprecated
public class JuDbUtils {
    static Logger log = LoggerFactory.getLogger(JuDbUtils.class);
    @Autowired
    private DataSource dataSource;
    @Autowired
    private ConnectionInfo connectionInfo;
    private EntityManagerFactory emf;

    public void setEntityManagerFactory(EntityManagerFactory emf) {
        this.emf = emf;
    }

    public static JuDbUtils createByPersistenceUnitName(String persistenceUnitName) {
        JuDbUtils utils = new JuDbUtils();
        utils.setEntityManagerFactory(Persistence.createEntityManagerFactory((String)persistenceUnitName));
        return utils;
    }

    public static boolean isSpringTransactionActive() {
        return TransactionSynchronizationManager.isActualTransactionActive();
    }

    public static <T> T getJpaRepository(EntityManager em, Class<T> repositoryClass) {
        JpaRepositoryFactory repositoryFactory = new JpaRepositoryFactory(em);
        return (T)repositoryFactory.getRepository(repositoryClass);
    }

    @Transactional
    public void createDefaultTables() {
        AssertUtil.assertNotNull((String)"EntityManagerFactory needs to be injected to create default tables", (Object)this.emf);
        EntityManager em = this.emf.createEntityManager();
        final Configuration conf = new Configuration();
        for (Class<?> clazz : JuDbUtils.getManagedTypesAsClass(em)) {
            conf.addAnnotatedClass(clazz);
        }
        conf.getProperties().put("hibernate.dialect", this.emf.getProperties().get("hibernate.dialect"));
        Session session = (Session)em.getDelegate();
        session.doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                SchemaExport export = new SchemaExport(conf, connection);
                export.create(true, true);
            }
        });
        em.close();
    }

    public static void doWork(EntityManager em, Work work) {
        Session session = (Session)em.unwrap(Session.class);
        session.doWork(work);
    }

    public void doWork(final Work work) {
        this.doWork(new EmWork(){

            @Override
            public void execute(EntityManager em) {
                JuDbUtils.doWork(em, work);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWork(EmWork work) {
        try (EntityManager em = null;){
            em = this.emf.createEntityManager();
            em.getTransaction().begin();
            try {
                work.execute(em);
                em.getTransaction().commit();
            }
            catch (Exception ex) {
                em.getTransaction().rollback();
                throw ex;
            }
        }
    }

    public static List<Class<?>> getManagedTypesAsClass(EntityManager em) {
        ArrayList classes = new ArrayList();
        for (ManagedType t : em.getMetamodel().getManagedTypes()) {
            Class clazz = t.getJavaType();
            classes.add(clazz);
        }
        return classes;
    }

    public static void commitAndClose(Connection conn) throws JuDbException {
        try {
            log.debug("Commiting and closing connection [ID=" + JuObjectUtils.getIdentityString((Object)conn) + "]");
            DbUtils.commitAndClose((Connection)conn);
        }
        catch (SQLException ex) {
            throw new JuDbException("Couldn't commit and close connection", ex);
        }
    }

    public static void rollbackAndClose(Connection conn) throws JuDbException {
        try {
            log.debug("Rolling back and closing connection [ID=" + JuObjectUtils.getIdentityString((Object)conn) + "]");
            DbUtils.rollbackAndClose((Connection)conn);
        }
        catch (SQLException ex) {
            throw new JuDbException("Couldn't roll back and close connection", ex);
        }
    }

    public static void closeQuietly(Connection conn) {
        try {
            log.debug("Closing connection [ID=" + JuObjectUtils.getIdentityString((Object)conn) + "]");
            DbUtils.close((Connection)conn);
        }
        catch (SQLException ex) {
            log.error("Couldn't close connection", (Throwable)ex);
        }
    }

    public static void closeQuietly(ResultSet rs) {
        try {
            DbUtils.close((ResultSet)rs);
        }
        catch (SQLException ex) {
            log.error("Couldn't close connection", (Throwable)ex);
        }
    }

    public static String getClobString(Clob clob) throws JuDbException {
        if (clob == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(clob.getCharacterStream());
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (Exception ex) {
            try {
                throw new JuDbException("Couldn't convert CLOB to String", ex);
            }
            catch (Throwable throwable) {
                IOUtil.close(reader);
                throw throwable;
            }
        }
        IOUtil.close((Reader)reader);
        return sb.toString();
    }

    public List<String> getTableNames() throws JuDbException {
        try {
            List tableNames = (List)JdbcUtils.extractDatabaseMetaData((DataSource)this.dataSource, (DatabaseMetaDataCallback)new DatabaseMetaDataCallback(){

                public Object processMetaData(DatabaseMetaData dbmd) throws SQLException, MetaDataAccessException {
                    ResultSet rs = dbmd.getTables(JuDbUtils.this.connectionInfo.getSchema(), null, null, new String[]{"TABLE"});
                    ArrayList<String> tableNames = new ArrayList<String>();
                    while (rs.next()) {
                        String tableName = rs.getString("TABLE_NAME").toUpperCase();
                        if (tableNames.contains(tableName)) continue;
                        tableNames.add(tableName);
                    }
                    rs.close();
                    Collections.sort(tableNames);
                    return tableNames;
                }
            });
            return tableNames;
        }
        catch (Exception ex) {
            throw new JuDbException("Couldn't evaluate table names", ex);
        }
    }

    public String getPrimaryColumnName(final String tableName) throws JuDbException {
        try {
            String columnName = (String)JdbcUtils.extractDatabaseMetaData((DataSource)this.dataSource, (DatabaseMetaDataCallback)new DatabaseMetaDataCallback(){

                public Object processMetaData(DatabaseMetaData dbmd) throws SQLException, MetaDataAccessException {
                    ResultSet rs = dbmd.getPrimaryKeys(null, null, tableName.toUpperCase());
                    String columnName = null;
                    if (!rs.next()) {
                        throw new JuDbException("Couldn't evaluate primary key for table " + tableName);
                    }
                    columnName = rs.getString("COLUMN_NAME");
                    if (rs.next()) {
                        throw new JuDbException("Driver returned multiple primary keys for table " + tableName);
                    }
                    rs.close();
                    return columnName.toUpperCase();
                }
            });
            return columnName;
        }
        catch (Exception ex) {
            throw new JuDbException("Couldn't evaluate primary column name", ex);
        }
    }

    public List<String> getColumnNames(final String tableName) throws JuDbException {
        try {
            List columnNames = (List)JdbcUtils.extractDatabaseMetaData((DataSource)this.dataSource, (DatabaseMetaDataCallback)new DatabaseMetaDataCallback(){

                public Object processMetaData(DatabaseMetaData dbmd) throws SQLException, MetaDataAccessException {
                    ResultSet rs = dbmd.getColumns(null, null, tableName.toUpperCase(), null);
                    ArrayList<String> columnNames = new ArrayList<String>();
                    while (rs.next()) {
                        String columnName = rs.getString("COLUMN_NAME");
                        columnNames.add(columnName.toUpperCase());
                    }
                    rs.close();
                    if (columnNames.size() == 0) {
                        throw new JuDbException("Couldn't evaluate column names for table " + tableName + ": Driver returned empty ResultSet.");
                    }
                    return columnNames;
                }
            });
            return columnNames;
        }
        catch (Exception ex) {
            throw new JuDbException("Couldn't evaluate primary column name", ex);
        }
    }

    public void oracleSequenceSetNextVal(String sequenceName, long nextVal) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        Long currentValue = jdbcTemplate.queryForLong(String.format("SELECT %s.NEXTVAL from dual", sequenceName));
        Long increment = nextVal - currentValue - 1L;
        jdbcTemplate.execute(String.format("ALTER SEQUENCE %s INCREMENT BY %d", sequenceName, increment));
        jdbcTemplate.execute(String.format("SELECT %s.NEXTVAL from dual", sequenceName));
        jdbcTemplate.execute(String.format("ALTER SEQUENCE %s INCREMENT BY 1", sequenceName));
    }
}

