/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.db;

import ch.inftec.ju.db.DbSpecificHandlerDefault;
import ch.inftec.ju.db.JuEmUtil;
import ch.inftec.ju.util.ConversionUtils;
import java.util.List;
import javax.persistence.EntityManager;

public class DbSpecificHandlerOracle
extends DbSpecificHandlerDefault {
    public DbSpecificHandlerOracle(JuEmUtil emUtil, EntityManager em) {
        super(emUtil, em);
    }

    @Override
    public List<String> getSequenceNames() {
        List results = this.em.createNativeQuery("select SEQUENCE_NAME from USER_SEQUENCES").getResultList();
        return results;
    }

    @Override
    public void resetIdentityGenerationOrSequences(int val) {
        for (String sequence : this.getSequenceNames()) {
            this.em.createNativeQuery("drop sequence " + sequence).executeUpdate();
            this.em.createNativeQuery(String.format("create sequence %s start with %d", sequence, val)).executeUpdate();
        }
    }

    @Override
    public Long getNextValueFromSequence(String sequenceName) {
        return ConversionUtils.toLong((Object)this.em.createNativeQuery(String.format("select %s.nextVal from dual", sequenceName)).getSingleResult());
    }
}

