/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.db;

import ch.inftec.ju.db.ConnectionInfo;
import ch.inftec.ju.db.ConnectionInfoContextHolder;
import ch.inftec.ju.db.ConnectionInfoDriverManagerDataSource;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;

public class ConnectionInfoRoutingDataSource
extends AbstractRoutingDataSource {
    final Logger logger = LoggerFactory.getLogger(ConnectionInfoRoutingDataSource.class);
    @Autowired
    private ConnectionInfoContextHolder contextHolder;

    protected Object determineCurrentLookupKey() {
        ConnectionInfo connectionInfo = this.contextHolder.getConnectionInfo();
        this.logger.debug("Determining lookup key -> " + connectionInfo);
        return connectionInfo;
    }

    public void setTargetDataSources(Map targetDataSources) {
        Set<ConnectionInfo> connectionInfos = targetDataSources.keySet();
        this.contextHolder.setAvailableConnectionInfos(connectionInfos);
        super.setTargetDataSources(targetDataSources);
    }

    public void setTargetConnectionInfoDataSources(List<ConnectionInfoDriverManagerDataSource> dataSources) {
        LinkedHashMap<ConnectionInfo, ConnectionInfoDriverManagerDataSource> map = new LinkedHashMap<ConnectionInfo, ConnectionInfoDriverManagerDataSource>();
        for (ConnectionInfoDriverManagerDataSource dataSource : dataSources) {
            map.put(dataSource.getConnectionInfo(), dataSource);
        }
        this.setTargetDataSources(map);
    }
}

