/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.db;

import ch.inftec.ju.db.ConnectionInfo;
import ch.inftec.ju.db.JuDbException;
import java.util.LinkedHashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionInfoContextHolder {
    final Logger logger = LoggerFactory.getLogger(ConnectionInfoContextHolder.class);
    private final ThreadLocal<ConnectionInfo> contextHolder = new ThreadLocal();
    private Set<ConnectionInfo> availableConnectionInfos = new LinkedHashSet<ConnectionInfo>();

    public void setConnectionInfo(ConnectionInfo connectionInfo) {
        this.logger.debug("Setting ConnectionInfo: " + connectionInfo);
        this.contextHolder.set(connectionInfo);
    }

    public void setConnectionInfoByName(String connectionInfoName) {
        for (ConnectionInfo connectionInfo : this.availableConnectionInfos) {
            if (!connectionInfoName.equals(connectionInfo.getName())) continue;
            this.setConnectionInfo(connectionInfo);
            return;
        }
        throw new JuDbException("No ConnectionInfo available by the name " + connectionInfoName);
    }

    public ConnectionInfo getConnectionInfo() {
        return this.contextHolder.get();
    }

    public void clearConnectionInfo() {
        this.contextHolder.remove();
    }

    void setAvailableConnectionInfos(Set<ConnectionInfo> availableConnectionInfos) {
        this.availableConnectionInfos = availableConnectionInfos;
    }

    public Set<ConnectionInfo> getAvailableConnectionInfos() {
        return this.availableConnectionInfos;
    }

    public boolean hasConnectionInfo(String name) {
        for (ConnectionInfo connectionInfo : this.getAvailableConnectionInfos()) {
            if (!connectionInfo.getName().equals(name)) continue;
            return true;
        }
        return false;
    }
}

