/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.testing.db;

import ch.inftec.ju.db.JuEmUtil;
import ch.inftec.ju.testing.db.AbstractDbTest;
import ch.inftec.ju.testing.db.DbSchemaUtil;
import ch.inftec.ju.testing.db.data.entity.DataTypes;
import ch.inftec.ju.util.JuStringUtils;
import java.text.ParseException;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class DefaultTestDataTest
extends AbstractDbTest {
    @Test
    public void tableStructure_canBeCreatedUsingLiquibase() {
        DbSchemaUtil su = new DbSchemaUtil(this.em);
        su.clearSchema();
        su.runLiquibaseChangeLog("ju-testing/data/default-changeLog.xml");
    }

    @Test
    public void defaultTestData_canBeLoaded() {
        new DbSchemaUtil(this.em).prepareDefaultSchemaAndTestData();
    }

    @Test
    public void defaultTestData_canBeLoadedTwice() {
        new DbSchemaUtil(this.em).prepareDefaultSchemaAndTestData();
        new DbSchemaUtil(this.em).prepareDefaultSchemaAndTestData();
    }

    @Test
    public void canRead_allDataTypes_fromDefaultTestData() throws ParseException {
        new DbSchemaUtil(this.em).prepareDefaultSchemaAndTestData();
        DataTypes dt1 = (DataTypes)this.em.find(DataTypes.class, (Object)-1L);
        Assert.assertEquals((Object)new Integer(1), (Object)dt1.getIntNumber());
        Assert.assertEquals((Object)new Long(2L), (Object)dt1.getBigIntNumber());
        Assert.assertEquals((Object)"one", (Object)dt1.getVarcharText());
        Assert.assertEquals((Object)"oneClob", (Object)dt1.getClobText());
        Assert.assertEquals((Object)JuStringUtils.DATE_FORMAT_DAYS.parseObject("03.12.1980"), (Object)dt1.getDateField());
        if (this.emUtil.getDbType() != JuEmUtil.DbType.ORACLE) {
            String hours = JuStringUtils.DATE_FORMAT_SECONDS.format(dt1.getTimeField());
            Assert.assertTrue((boolean)hours.endsWith("10:11:12"));
        }
        Assert.assertEquals((Object)JuStringUtils.DATE_FORMAT_SECONDS.parseObject("03.12.1980 10:11:12"), (Object)dt1.getTimeStampField());
    }

    @Test
    public void canRead_allNullValues_fromDefaultTestData() throws ParseException {
        new DbSchemaUtil(this.em).prepareDefaultSchemaAndTestData();
        DataTypes dt2 = (DataTypes)this.em.find(DataTypes.class, (Object)-2L);
        Assert.assertNull((Object)dt2.getIntNumber());
        Assert.assertNull((Object)dt2.getBigIntNumber());
        Assert.assertNull((Object)dt2.getVarcharText());
        Assert.assertNull((Object)dt2.getClobText());
        Assert.assertNull((Object)dt2.getDateField());
        Assert.assertNull((Object)dt2.getTimeField());
        Assume.assumeTrue((this.emUtil.getDbType() != JuEmUtil.DbType.MYSQL ? 1 : 0) != 0);
        Assert.assertNull((Object)dt2.getTimeStampField());
    }
}

