/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.testing.db;

import ch.inftec.ju.db.JuEmUtil;
import ch.inftec.ju.testing.db.AbstractDbTest;
import ch.inftec.ju.testing.db.DbDataUtil;
import ch.inftec.ju.testing.db.DbSchemaUtil;
import ch.inftec.ju.testing.db.JuAssumeUtils;
import ch.inftec.ju.testing.db.data.entity.TestingEntity;
import ch.inftec.ju.util.JuUrl;
import ch.inftec.ju.util.xml.XPathGetter;
import ch.inftec.ju.util.xml.XmlUtils;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import junit.framework.ComparisonFailure;
import org.hibernate.jdbc.Work;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DbDataUtilTest
extends AbstractDbTest {
    @Test
    public void canImportData_fromDatasetFile() {
        DbSchemaUtil ds = new DbSchemaUtil(this.em);
        ds.prepareDefaultTestData(true, true, true);
        DbDataUtil du = new DbDataUtil(this.em);
        du.cleanImport("/ch/inftec/ju/testing/db/DbDataUtilTest_testingEntity.xml");
        TestingEntity te = (TestingEntity)this.em.find(TestingEntity.class, (Object)1L);
        Assert.assertEquals((Object)"DbDataUtilTest", (Object)te.getName());
    }

    @Test
    public void canExportData_toXmlDocument() {
        DbSchemaUtil ds = new DbSchemaUtil(this.em);
        ds.prepareDefaultTestData(true, true, true);
        TestingEntity te = new TestingEntity();
        te.setName("Export Test");
        this.em.persist((Object)te);
        DbDataUtil du = new DbDataUtil(this.em);
        Document doc = du.buildExport().addTable("TestingEntity").writeToXmlDocument();
        XPathGetter xg = new XPathGetter((Node)doc);
        this.logger.debug("Exported XML\n" + XmlUtils.toString((Document)doc, (boolean)false, (boolean)true));
        Assert.assertEquals((long)1L, (long)xg.getArray("//TestingEntity").length);
        Assert.assertEquals((Object)"Export Test", (Object)xg.getSingle("//TestingEntity/@name"));
    }

    @Test
    public void xmlExport_copesWithCamelCaseTable_andUsesUpperCaseColumnNames() {
        DbSchemaUtil ds = new DbSchemaUtil(this.em);
        ds.prepareDefaultTestData(true, true, true);
        TestingEntity te = new TestingEntity();
        te.setName("Export Test");
        this.em.persist((Object)te);
        DbDataUtil du = new DbDataUtil(this.em);
        Document doc = du.buildExport().addTable("TestingEntity").writeToXmlDocument();
        XPathGetter xg = new XPathGetter((Node)doc);
        this.logger.debug("Exported XML\n" + XmlUtils.toString((Document)doc, (boolean)false, (boolean)true));
        Assert.assertEquals((long)1L, (long)xg.getArray("//TestingEntity").length);
        Assert.assertEquals((Object)"Export Test", (Object)xg.getSingle("//TestingEntity/@name"));
    }

    @Test
    public void xmlExport_copesWithLowerCaseTable_andUsesUpperCaseColumnNames() {
        JuAssumeUtils.dbIsNot((JuEmUtil)this.emUtil, (JuEmUtil.DbType[])new JuEmUtil.DbType[]{JuEmUtil.DbType.MYSQL});
        DbSchemaUtil ds = new DbSchemaUtil(this.em);
        ds.prepareDefaultTestData(true, true, true);
        TestingEntity te = new TestingEntity();
        te.setName("Export Test");
        this.em.persist((Object)te);
        DbDataUtil du = new DbDataUtil(this.em);
        Document doc = du.buildExport().addTable("testingentity").writeToXmlDocument();
        XPathGetter xg = new XPathGetter((Node)doc);
        this.logger.debug("Exported XML\n" + XmlUtils.toString((Document)doc, (boolean)false, (boolean)true));
        Assert.assertEquals((long)1L, (long)xg.getArray("//testingentity").length);
        Assert.assertEquals((Object)"Export Test", (Object)xg.getSingle("//testingentity/@name"));
    }

    @Test
    public void xmlExport_copesWithUpperCaseTable_andUsesUpperCaseColumnNames() {
        JuAssumeUtils.dbIsNot((JuEmUtil)this.emUtil, (JuEmUtil.DbType[])new JuEmUtil.DbType[]{JuEmUtil.DbType.MYSQL});
        DbSchemaUtil ds = new DbSchemaUtil(this.em);
        ds.prepareDefaultTestData(true, true, true);
        TestingEntity te = new TestingEntity();
        te.setName("Export Test");
        this.em.persist((Object)te);
        DbDataUtil du = new DbDataUtil(this.em);
        Document doc = du.buildExport().addTable("TESTINGENTITY").writeToXmlDocument();
        XPathGetter xg = new XPathGetter((Node)doc);
        this.logger.debug("Exported XML\n" + XmlUtils.toString((Document)doc, (boolean)false, (boolean)true));
        Assert.assertEquals((long)1L, (long)xg.getArray("//TESTINGENTITY").length);
        Assert.assertEquals((Object)"Export Test", (Object)xg.getSingle("//TESTINGENTITY/@name"));
    }

    @Test
    public void xmlExport_canApply_casedTableNames() {
        DbSchemaUtil ds = new DbSchemaUtil(this.em);
        ds.prepareDefaultTestData(true, true, true);
        TestingEntity te = new TestingEntity();
        te.setName("Export Test");
        this.em.persist((Object)te);
        DbDataUtil du = new DbDataUtil(this.em);
        Document doc = du.buildExport().addTable("TESTINGENTITY").setTableNamesCasingByDataSet("/ch/inftec/ju/testing/db/DbDataUtilTest_testingEntity.xml").writeToXmlDocument();
        XPathGetter xg = new XPathGetter((Node)doc);
        this.logger.debug("Exported XML\n" + XmlUtils.toString((Document)doc, (boolean)false, (boolean)true));
        Assert.assertEquals((long)1L, (long)xg.getArray("//TestingEntity").length);
        Assert.assertEquals((Object)"Export Test", (Object)xg.getSingle("//TestingEntity/@name"));
    }

    @Test
    public void canExportTables_basedOnDatasetXml() {
        DbSchemaUtil ds = new DbSchemaUtil(this.em);
        ds.prepareDefaultTestData(true, true, true);
        TestingEntity te = new TestingEntity();
        te.setName("Export Test");
        this.em.persist((Object)te);
        DbDataUtil du = new DbDataUtil(this.em);
        Document doc = du.buildExport().addTablesByDataSet(JuUrl.resource((String)"ch/inftec/ju/testing/db/DbDataUtilTest_testingEntity.xml"), false).writeToXmlDocument();
        XPathGetter xg = new XPathGetter((Node)doc);
        this.logger.debug("Exported XML\n" + XmlUtils.toString((Document)doc, (boolean)false, (boolean)true));
        Assert.assertEquals((long)1L, (long)xg.getArray("//TestingEntity").length);
        Assert.assertEquals((Object)"Export Test", (Object)xg.getSingle("//TestingEntity/@name"));
    }

    @Test
    public void exportTables_areSortedByPrimaryKey() {
        DbSchemaUtil ds = new DbSchemaUtil(this.em);
        ds.prepareDefaultTestData(true, true, true);
        DbDataUtil du = new DbDataUtil(this.em);
        du.cleanImport("/ch/inftec/ju/testing/db/DbDataUtilTest_testingEntity_unsorted.xml");
        Document doc = du.buildExport().addTableSorted("TestingEntity").writeToXmlDocument();
        XPathGetter xg = new XPathGetter((Node)doc);
        this.logger.debug("Exported XML\n" + XmlUtils.toString((Document)doc, (boolean)false, (boolean)true));
        Assert.assertEquals((long)3L, (long)xg.getArray("//TestingEntity").length);
        Assert.assertEquals((Object)"1", (Object)xg.getSingle("//TestingEntity[1]/@id"));
        Assert.assertEquals((Object)"2", (Object)xg.getSingle("//TestingEntity[2]/@id"));
        Assert.assertEquals((Object)"3", (Object)xg.getSingle("//TestingEntity[3]/@id"));
    }

    @Test
    public void exportTables_basedOnDatasetXml_areSortedByPrimaryKey() {
        DbSchemaUtil ds = new DbSchemaUtil(this.em);
        ds.prepareDefaultTestData(true, true, true);
        DbDataUtil du = new DbDataUtil(this.em);
        du.cleanImport("/ch/inftec/ju/testing/db/DbDataUtilTest_testingEntity_unsorted.xml");
        Document doc = du.buildExport().addTablesByDataSet(JuUrl.resource((String)"ch/inftec/ju/testing/db/DbDataUtilTest_testingEntity.xml"), true).writeToXmlDocument();
        XPathGetter xg = new XPathGetter((Node)doc);
        this.logger.debug("Exported XML\n" + XmlUtils.toString((Document)doc, (boolean)false, (boolean)true));
        Assert.assertEquals((long)3L, (long)xg.getArray("//TestingEntity").length);
        Assert.assertEquals((Object)"1", (Object)xg.getSingle("//TestingEntity[1]/@id"));
        Assert.assertEquals((Object)"2", (Object)xg.getSingle("//TestingEntity[2]/@id"));
        Assert.assertEquals((Object)"3", (Object)xg.getSingle("//TestingEntity[3]/@id"));
    }

    @Test
    public void assert_canAssertTables() {
        DbSchemaUtil ds = new DbSchemaUtil(this.em);
        ds.prepareDefaultTestData(true, true, true);
        DbDataUtil du = new DbDataUtil(this.emUtil);
        du.cleanImport("/ch/inftec/ju/testing/db/DbDataUtilTest_testingEntity_unsorted.xml");
        du.buildAssert().expected("/ch/inftec/ju/testing/db/DbDataUtilTest_testingEntity_sorted.xml").assertEquals();
    }

    @Test(expected=ComparisonFailure.class)
    public void assert_canAssertTables_failsOnWrongData() {
        DbSchemaUtil ds = new DbSchemaUtil(this.em);
        ds.prepareDefaultTestData(true, true, true);
        DbDataUtil du = new DbDataUtil(this.emUtil);
        du.cleanImport("/ch/inftec/ju/testing/db/DbDataUtilTest_testingEntity_unsorted.xml");
        du.buildAssert().expected("/ch/inftec/ju/testing/db/DbDataUtilTest_testingEntity.xml").assertEquals();
    }

    @Test
    public void canImport_usingJdbcConnection() {
        DbSchemaUtil ds = new DbSchemaUtil(this.em);
        ds.prepareDefaultTestData(true, true, true);
        this.emUtil.doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                URL url = JuUrl.resource((String)"ch/inftec/ju/testing/db/DbDataUtilTest_jdbcConnectionImport.xml");
                DbDataUtil.executeInsert((Connection)connection, (URL)url, (boolean)true);
            }
        });
        TestingEntity te = (TestingEntity)this.em.find(TestingEntity.class, (Object)1L);
        Assert.assertEquals((Object)"DbDataUtilTest.jdbcConnection", (Object)te.getName());
    }
}

