/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.dbutil.test;

import ch.inftec.ju.db.DatabaseMetaDataCallback;
import ch.inftec.ju.db.JuEmUtil;
import ch.inftec.ju.testing.db.AbstractDbTest;
import ch.inftec.ju.testing.db.DbSchemaUtil;
import ch.inftec.ju.testing.db.JuAssumeUtils;
import ch.inftec.ju.testing.db.data.entity.TestingEntity;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class JuEmUtilTest
extends AbstractDbTest {
    @Test
    public void processMetaData() {
        String url = (String)this.emUtil.extractDatabaseMetaData((DatabaseMetaDataCallback)new DatabaseMetaDataCallback<String>(){

            public String processMetaData(DatabaseMetaData dbmd) throws SQLException {
                return dbmd.getURL();
            }
        });
        this.logger.debug("Got DB URL: " + url);
        Assert.assertTrue((boolean)url.startsWith("jdbc:"));
    }

    @Test
    public void getDriverName_returnsNotNull() {
        Assert.assertNotNull((Object)this.emUtil.getDbType());
    }

    @Test
    public void getMetaDataUserName_returnsNotNull() {
        Assert.assertNotNull((Object)this.emUtil.getMetaDataUserName());
    }

    @Test
    public void canListSequences() {
        JuAssumeUtils.dbIsNot((JuEmUtil)this.emUtil, (JuEmUtil.DbType[])new JuEmUtil.DbType[]{JuEmUtil.DbType.MYSQL});
        new DbSchemaUtil(this.emUtil).runLiquibaseChangeLog("ch/inftec/ju/dbutil/test/JuEmUtilTest_canListSequences.xml");
        List sequenceNames = this.emUtil.getSequenceNames();
        Assert.assertTrue((boolean)sequenceNames.contains("TESTSEQUENCE"));
    }

    @Test
    public void canResetIdentityGeneration_forPrimeryKeys() {
        new DbSchemaUtil(this.emUtil).prepareDefaultSchemaAndTestData();
        this.emUtil.resetIdentityGenerationOrSequences(10);
        TestingEntity te1 = new TestingEntity();
        this.em.persist((Object)te1);
        Assert.assertEquals((Object)new Long(10L), (Object)te1.getId());
        this.em.createQuery("delete from TestingEntity t").executeUpdate();
        this.emUtil.resetIdentityGenerationOrSequences(1);
        TestingEntity te2 = new TestingEntity();
        this.em.persist((Object)te2);
        Assert.assertEquals((Object)new Long(1L), (Object)te2.getId());
    }

    @Test
    public void canResetIdentityGeneration_forSequences() {
        JuAssumeUtils.dbIsNot((JuEmUtil)this.emUtil, (JuEmUtil.DbType[])new JuEmUtil.DbType[]{JuEmUtil.DbType.MYSQL});
        DbSchemaUtil su = new DbSchemaUtil(this.emUtil);
        su.prepareDefaultSchemaAndTestData();
        su.runLiquibaseChangeLog("ch/inftec/ju/dbutil/test/JuEmUtilTest_canListSequences.xml");
        this.emUtil.resetIdentityGenerationOrSequences(1);
        Assert.assertEquals((Object)new Long(1L), (Object)this.emUtil.getNextValueFromSequence("testSequence"));
        this.emUtil.resetIdentityGenerationOrSequences(10);
        Assert.assertEquals((Object)new Long(10L), (Object)this.emUtil.getNextValueFromSequence("testSequence"));
    }

    @Test
    public void canEvaluate_primaryKeyColumnName_withSingleColumn() {
        new DbSchemaUtil(this.emUtil).prepareDefaultSchemaAndTestData();
        List primaryKeyColumns = this.emUtil.getPrimaryKeyColumns("TestingEntity");
        Assert.assertEquals((long)1L, (long)primaryKeyColumns.size());
        Assert.assertEquals((Object)"id", (Object)((String)primaryKeyColumns.get(0)).toLowerCase());
    }

    @Test
    public void canEvaluate_primaryKeyColumnName_withMultipleColumns() {
        new DbSchemaUtil(this.emUtil).prepareDefaultSchemaAndTestData();
        List primaryKeyColumns = this.emUtil.getPrimaryKeyColumns("Team_Player");
        Assert.assertEquals((long)2L, (long)primaryKeyColumns.size());
        Assert.assertEquals((Object)"players_id", (Object)((String)primaryKeyColumns.get(0)).toLowerCase());
        Assert.assertEquals((Object)"teams_id", (Object)((String)primaryKeyColumns.get(1)).toLowerCase());
    }
}

