/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.dbutil.test;

import ch.inftec.ju.testing.db.AbstractDbTest;
import ch.inftec.ju.testing.db.DbSchemaUtil;
import ch.inftec.ju.util.JuCollectionUtils;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;

public class DbSchemaUtilTest
extends AbstractDbTest {
    @Test
    public void tablesAreCreated_usingLiquibaseExplicitly() {
        DbSchemaUtil su = new DbSchemaUtil(this.em);
        su.clearSchema();
        Assert.assertFalse((boolean)JuCollectionUtils.collectionContainsIgnoreCase((Collection)this.emUtil.getTableNames(), (String[])new String[]{"TestingEntity_LB"}));
        su.runLiquibaseChangeLog("ch/inftec/ju/dbutil/test/LiquibaseTestDataTest_testingEntity.xml");
        Assert.assertTrue((boolean)JuCollectionUtils.collectionContainsIgnoreCase((Collection)this.emUtil.getTableNames(), (String[])new String[]{"TestingEntity_LB"}));
    }

    @Test
    public void tablesAreCreated_usingFlywayExplicitly() {
        DbSchemaUtil su = new DbSchemaUtil(this.em);
        su.clearSchema();
        Assert.assertFalse((boolean)JuCollectionUtils.collectionContainsIgnoreCase((Collection)this.emUtil.getTableNames(), (String[])new String[]{"TESTINGENTITY_FW"}));
        su.runFlywayMigration(new String[]{"db/DbSchemaUtilTest-migration"});
        Assert.assertTrue((boolean)JuCollectionUtils.collectionContainsIgnoreCase((Collection)this.emUtil.getTableNames(), (String[])new String[]{"TESTINGENTITY_FW"}));
    }

    @Test
    public void liquibase_canUseReplaceOrExists() {
        DbSchemaUtil su = new DbSchemaUtil(this.em);
        su.clearSchema();
        su.runLiquibaseChangeLog("ch/inftec/ju/dbutil/test/DbSchemaUtilTest_liquibase_canUseReplaceOrExists.xml");
    }
}

