/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.ju.dbutil.test;

import ch.inftec.ju.db.EmfWork;
import ch.inftec.ju.db.JuEmUtil;
import ch.inftec.ju.db.JuEmfUtil;
import ch.inftec.ju.testing.db.AbstractDbTest;
import ch.inftec.ju.testing.db.DataSet;
import ch.inftec.ju.testing.db.DataSetExport;
import ch.inftec.ju.testing.db.DataVerifier;
import ch.inftec.ju.testing.db.DataVerify;
import ch.inftec.ju.testing.db.DbSchemaUtil;
import ch.inftec.ju.testing.db.JuAssumeUtils;
import ch.inftec.ju.testing.db.data.entity.TestingEntity;
import org.junit.Assert;
import org.junit.Test;

public class AbstractDbTestTransactionTest
extends AbstractDbTest {
    protected void runDbInitializationScripts(JuEmfUtil emfUtil) {
        try (EmfWork ew = emfUtil.startWork();){
            new DbSchemaUtil(ew.getEm()).prepareDefaultSchemaAndTestData();
        }
    }

    @Test
    @DataSet(value="AbstractDbTestTransactionTest_testingEntity.xml")
    @DataVerify
    @DataSetExport(tablesDataSet="AbstractDbTestTransactionTest_testingEntity.xml", doPhysicalExport=false)
    public void transaction_isCommitted() {
        ((TestingEntity)this.em.find(TestingEntity.class, (Object)-1L)).setName("DoCommit");
    }

    @Test
    @DataSet(value="AbstractDbTestTransactionTest_testingEntity.xml")
    @DataVerify
    @DataSetExport(tablesDataSet="AbstractDbTestTransactionTest_testingEntity.xml", doPhysicalExport=false)
    public void transaction_isRolledBack() {
        ((TestingEntity)this.em.find(TestingEntity.class, (Object)-1L)).setName("DoCommit");
        this.em.flush();
        this.setRollbackOnly();
    }

    @Test
    @DataSet(value="AbstractDbTestTransactionTest_testingEntity.xml")
    @DataVerify
    @DataSetExport(tablesDataSet="AbstractDbTestTransactionTest_testingEntity.xml", doPhysicalExport=false)
    public void multipleTransactions_areSupported() {
        JuAssumeUtils.dbIsNot((JuEmUtil)this.emUtil, (JuEmUtil.DbType[])new JuEmUtil.DbType[]{JuEmUtil.DbType.H2});
        TestingEntity te1 = new TestingEntity("TE1");
        this.em.persist((Object)te1);
        try (EmfWork ew2 = this.startNewWork();){
            TestingEntity te2 = new TestingEntity("TE2");
            ew2.getEm().persist((Object)te2);
            try (EmfWork ew3 = this.startNewWork();){
                TestingEntity te3 = new TestingEntity("TE3");
                ew3.getEm().persist((Object)te3);
            }
            ew2.setRollbackOnly();
        }
    }

    public static class MultipleTransactions_areSupported
    extends DataVerifier {
        public void verify() throws Exception {
            Assert.assertEquals((long)3L, (long)this.getXg().getCount("//TestingEntity"));
            Assert.assertEquals((Object)"TE1", (Object)this.getXg().getSingle("//TestingEntity[@id='1']/@name"));
            Assert.assertEquals((Object)"TE3", (Object)this.getXg().getSingle("//TestingEntity[@id='3']/@name"));
        }
    }

    public static class Transaction_isRolledBack
    extends DataVerifier {
        public void verify() throws Exception {
            Assert.assertEquals((Object)"TransactionTest", (Object)this.getXg().getSingle("//TestingEntity/@name"));
        }
    }

    public static class Transaction_isCommitted
    extends DataVerifier {
        public void verify() throws Exception {
            Assert.assertEquals((Object)"DoCommit", (Object)this.getXg().getSingle("//TestingEntity/@name"));
        }
    }
}

