/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.flyway.core;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.MigrationType;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.callback.FlywayCallback;
import org.flywaydb.core.internal.dbsupport.DbSupport;
import org.flywaydb.core.internal.dbsupport.DbSupportFactory;
import org.flywaydb.core.internal.dbsupport.JdbcTemplate;
import org.flywaydb.core.internal.metadatatable.AppliedMigration;
import org.flywaydb.core.internal.util.jdbc.RowMapper;
import org.flywaydb.core.internal.util.logging.Log;
import org.flywaydb.core.internal.util.logging.LogFactory;

public class RepeatableCallback
implements FlywayCallback {
    private static final Log LOG = LogFactory.getLog(RepeatableCallback.class);
    private final Flyway flyway;
    private List<AppliedMigration> appliedMigrations;

    public RepeatableCallback(Flyway flyway) throws SQLException {
        this.flyway = flyway;
    }

    public void beforeClean(Connection connection) {
    }

    public void afterClean(Connection connection) {
    }

    public void beforeMigrate(Connection connection) {
        try {
            DbSupport dbSupport = DbSupportFactory.createDbSupport((Connection)connection, (boolean)false);
            if (!dbSupport.getCurrentSchema().getTable(this.flyway.getTable()).exists()) {
                return;
            }
            String sql = "DELETE FROM " + this.flyway.getTable() + " WHERE " + dbSupport.quote(new String[]{"type"}) + "='CUSTOM'";
            connection.prepareCall(sql).execute();
        }
        catch (SQLException e) {
            LOG.error(e.getMessage(), (Exception)e);
        }
    }

    public void afterMigrate(Connection connection) {
    }

    public void beforeEachMigrate(Connection connection, MigrationInfo info) {
    }

    public void afterEachMigrate(Connection connection, MigrationInfo info) {
    }

    public void beforeValidate(Connection connection) {
    }

    public void afterValidate(Connection connection) {
    }

    public void beforeInit(Connection connection) {
    }

    public void afterInit(Connection connection) {
    }

    public void beforeRepair(Connection connection) {
    }

    public void afterRepair(Connection connection) {
    }

    public void beforeInfo(Connection connection) {
        try {
            DbSupport dbSupport = DbSupportFactory.createDbSupport((Connection)connection, (boolean)false);
            JdbcTemplate jdbcTemplate = dbSupport.getJdbcTemplate();
            String query = "SELECT " + dbSupport.quote(new String[]{"version_rank"}) + "," + dbSupport.quote(new String[]{"installed_rank"}) + "," + dbSupport.quote(new String[]{"version"}) + "," + dbSupport.quote(new String[]{"description"}) + "," + dbSupport.quote(new String[]{"type"}) + "," + dbSupport.quote(new String[]{"script"}) + "," + dbSupport.quote(new String[]{"checksum"}) + "," + dbSupport.quote(new String[]{"installed_on"}) + "," + dbSupport.quote(new String[]{"installed_by"}) + "," + dbSupport.quote(new String[]{"execution_time"}) + "," + dbSupport.quote(new String[]{"success"}) + " FROM " + this.flyway.getTable();
            query = query + " WHERE " + dbSupport.quote(new String[]{"type"}) + " = 'CUSTOM'";
            query = query + " ORDER BY " + dbSupport.quote(new String[]{"version_rank"});
            this.appliedMigrations = jdbcTemplate.query(query, (RowMapper)new RowMapper<AppliedMigration>(){

                public AppliedMigration mapRow(ResultSet rs) throws SQLException {
                    Integer checksum = rs.getInt("checksum");
                    if (rs.wasNull()) {
                        checksum = null;
                    }
                    return new AppliedMigration(rs.getInt("version_rank"), rs.getInt("installed_rank"), MigrationVersion.fromVersion((String)rs.getString("version")), rs.getString("description"), MigrationType.valueOf((String)rs.getString("type")), rs.getString("script"), checksum, (Date)rs.getTimestamp("installed_on"), rs.getString("installed_by"), rs.getInt("execution_time"), rs.getBoolean("success"));
                }
            });
            String sql = "DELETE FROM " + this.flyway.getTable() + " WHERE " + dbSupport.quote(new String[]{"type"}) + "='CUSTOM'";
            connection.prepareCall(sql).execute();
        }
        catch (SQLException e) {
            LOG.error(e.getMessage(), (Exception)e);
        }
    }

    public void afterInfo(Connection connection) {
        try {
            for (AppliedMigration appliedMigration : this.appliedMigrations) {
                DbSupport dbSupport = DbSupportFactory.createDbSupport((Connection)connection, (boolean)false);
                JdbcTemplate jdbcTemplate = dbSupport.getJdbcTemplate();
                jdbcTemplate.update("INSERT INTO " + this.flyway.getTable() + " (" + dbSupport.quote(new String[]{"version_rank"}) + "," + dbSupport.quote(new String[]{"installed_rank"}) + "," + dbSupport.quote(new String[]{"version"}) + "," + dbSupport.quote(new String[]{"description"}) + "," + dbSupport.quote(new String[]{"type"}) + "," + dbSupport.quote(new String[]{"script"}) + "," + dbSupport.quote(new String[]{"checksum"}) + "," + dbSupport.quote(new String[]{"installed_by"}) + "," + dbSupport.quote(new String[]{"execution_time"}) + "," + dbSupport.quote(new String[]{"success"}) + ")" + " VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", new Object[]{appliedMigration.getVersionRank(), appliedMigration.getInstalledRank(), appliedMigration.getVersion().getVersion(), appliedMigration.getDescription(), appliedMigration.getType().name(), appliedMigration.getScript(), appliedMigration.getChecksum(), appliedMigration.getInstalledBy(), appliedMigration.getExecutionTime(), appliedMigration.isSuccess()});
            }
        }
        catch (SQLException e) {
            LOG.error(e.getMessage(), (Exception)e);
        }
    }
}

