/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.flyway.core;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.flywaydb.core.internal.dbsupport.DbSupport;
import org.flywaydb.core.internal.dbsupport.DbSupportFactory;
import org.flywaydb.core.internal.dbsupport.SqlScript;
import org.flywaydb.core.internal.util.jdbc.DriverDataSource;
import org.flywaydb.core.internal.util.logging.Log;
import org.flywaydb.core.internal.util.logging.LogFactory;
import org.flywaydb.core.internal.util.scanner.filesystem.FileSystemResource;

public class SqlFileRunner {
    private static final Log LOG = LogFactory.getLog(SqlFileRunner.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int execute(File baseDirectory, String jdbcUrl, String jdbcUser, String jdbcPassword, String ... initSql) throws IOException, SQLException {
        if (baseDirectory == null || !baseDirectory.exists() || !baseDirectory.isDirectory()) {
            throw new IOException(String.format("directory %s should exists and be a directory", baseDirectory));
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        DriverDataSource ds = new DriverDataSource(classLoader, null, jdbcUrl, jdbcUser, jdbcPassword, initSql);
        DbSupport support = DbSupportFactory.createDbSupport((Connection)ds.getConnection(), (boolean)false);
        try {
            int filesExecuted = 0;
            ArrayList<File> sqlFiles = new ArrayList<File>();
            SqlFileRunner.collectSqlFiles(baseDirectory, sqlFiles);
            for (File sqlFile : sqlFiles) {
                FileSystemResource resource = new FileSystemResource(sqlFile.getAbsolutePath());
                SqlScript script = new SqlScript(resource.loadAsString("UTF-8"), support);
                LOG.info(String.format("execute sql file: %s%n", sqlFile.getAbsolutePath()));
                script.execute(support.getJdbcTemplate());
                ++filesExecuted;
            }
            int n = filesExecuted;
            return n;
        }
        finally {
            try {
                support.getJdbcTemplate().getConnection().close();
            }
            catch (SQLException e) {
                LOG.error(e.getMessage(), (Exception)e);
            }
        }
    }

    static void collectSqlFiles(File directory, List<File> collectedFiles) {
        for (String fileName : directory.list()) {
            File file = new File(directory, fileName);
            if (file.isDirectory()) {
                SqlFileRunner.collectSqlFiles(file, collectedFiles);
                continue;
            }
            if (!fileName.endsWith(".sql")) continue;
            collectedFiles.add(file);
        }
    }
}

