/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.flyway.core;

import ch.inftec.flyway.core.SqlFileRunner;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.callback.FlywayCallback;
import org.flywaydb.core.internal.util.ClassUtils;
import org.flywaydb.core.internal.util.logging.Log;
import org.flywaydb.core.internal.util.logging.LogFactory;

public class BeforeAfterCallback
implements FlywayCallback {
    private static final Log LOG = LogFactory.getLog(BeforeAfterCallback.class);
    private Properties properties;

    public BeforeAfterCallback(Properties properties) throws SQLException {
        this.properties = properties;
    }

    public void beforeClean(Connection connection) {
    }

    public void afterClean(Connection connection) {
    }

    public void beforeMigrate(Connection connection) {
        try {
            String beforeLocation = this.properties.getProperty("before.scripts.location");
            if (beforeLocation != null && beforeLocation.length() > 0) {
                String path = ClassUtils.getLocationOnDisk(BeforeAfterCallback.class);
                path = path.substring(0, path.lastIndexOf("/")) + "/..";
                File baseDir = new File(path + "/" + beforeLocation);
                String password = this.properties.getProperty("flyway.before.password");
                if (password == null || password.length() == 0) {
                    password = this.properties.getProperty("before.password");
                }
                int filesExecuted = SqlFileRunner.execute(baseDir, this.properties.getProperty("flyway.url"), this.properties.getProperty("before.user"), password, new String[0]);
                LOG.info(String.format("executed %d files%n", filesExecuted));
            }
        }
        catch (IOException | SQLException e) {
            LOG.error(e.getMessage(), e);
        }
    }

    public void afterMigrate(Connection connection) {
        try {
            String afterLocation = this.properties.getProperty("after.scripts.location");
            if (afterLocation != null && afterLocation.length() > 0) {
                String path = ClassUtils.getLocationOnDisk(BeforeAfterCallback.class);
                path = path.substring(0, path.lastIndexOf("/")) + "/..";
                File baseDir = new File(path + "/" + afterLocation);
                String password = this.properties.getProperty("flyway.after.password");
                if (password == null || password.length() == 0) {
                    password = this.properties.getProperty("after.password");
                }
                int filesExecuted = SqlFileRunner.execute(baseDir, this.properties.getProperty("flyway.url"), this.properties.getProperty("after.user"), password, new String[0]);
                LOG.info(String.format("executed %d files%n", filesExecuted));
            }
        }
        catch (IOException | SQLException e) {
            LOG.error(e.getMessage(), e);
        }
    }

    public void beforeEachMigrate(Connection connection, MigrationInfo info) {
    }

    public void afterEachMigrate(Connection connection, MigrationInfo info) {
    }

    public void beforeValidate(Connection connection) {
    }

    public void afterValidate(Connection connection) {
    }

    public void beforeInit(Connection connection) {
    }

    public void afterInit(Connection connection) {
    }

    public void beforeRepair(Connection connection) {
    }

    public void afterRepair(Connection connection) {
    }

    public void beforeInfo(Connection connection) {
    }

    public void afterInfo(Connection connection) {
    }
}

