/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.flyway.core;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.MigrationType;
import org.flywaydb.core.api.resolver.MigrationResolver;
import org.flywaydb.core.api.resolver.ResolvedMigration;
import org.flywaydb.core.internal.dbsupport.DbSupport;
import org.flywaydb.core.internal.dbsupport.DbSupportFactory;
import org.flywaydb.core.internal.resolver.ResolvedMigrationImpl;
import org.flywaydb.core.internal.resolver.sql.SqlMigrationResolver;
import org.flywaydb.core.internal.util.Location;
import org.flywaydb.core.internal.util.PlaceholderReplacer;

public class RepeatableMigrationResolver
implements MigrationResolver {
    private Flyway flyway;
    private final String prefix;
    private Location location;
    private DbSupport dbSupport;

    public RepeatableMigrationResolver(Flyway flyway, String prefix, Location location) throws SQLException {
        this.prefix = prefix;
        this.location = location;
        this.flyway = flyway;
        this.dbSupport = DbSupportFactory.createDbSupport((Connection)flyway.getDataSource().getConnection(), (boolean)false);
    }

    public Collection<ResolvedMigration> resolveMigrations() {
        SqlMigrationResolver delegate = new SqlMigrationResolver(this.dbSupport, null, this.getLocation(), this.getPlaceholderReplacer(), this.getEncoding(), this.getSqlMigrationPrefix(), this.flyway.getSqlMigrationSeparator(), this.getSqlMigrationSuffix());
        List resolvedMigrations = delegate.resolveMigrations();
        for (ResolvedMigration migration : resolvedMigrations) {
            ((ResolvedMigrationImpl)migration).setType(MigrationType.CUSTOM);
        }
        return resolvedMigrations;
    }

    public String getSqlMigrationSuffix() {
        return this.flyway.getSqlMigrationSuffix();
    }

    public Location getLocation() {
        return this.location;
    }

    public String getSqlMigrationPrefix() {
        return this.prefix;
    }

    public String getEncoding() {
        return this.flyway.getEncoding();
    }

    public PlaceholderReplacer getPlaceholderReplacer() {
        return new PlaceholderReplacer(this.flyway.getPlaceholders(), this.flyway.getPlaceholderPrefix(), this.flyway.getPlaceholderSuffix());
    }
}

