/*
 * Decompiled with CFR 0.152.
 */
package ch.inftec.flyway.commandline;

import ch.inftec.flyway.core.RepeatableFlyway;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.flywaydb.commandline.ConsoleLogCreator;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.internal.info.MigrationInfoDumper;
import org.flywaydb.core.internal.util.ClassUtils;
import org.flywaydb.core.internal.util.ExceptionUtils;
import org.flywaydb.core.internal.util.FileCopyUtils;
import org.flywaydb.core.internal.util.PropertiesUtils;
import org.flywaydb.core.internal.util.logging.Log;
import org.flywaydb.core.internal.util.logging.LogCreator;
import org.flywaydb.core.internal.util.logging.LogFactory;
import org.flywaydb.core.internal.util.scanner.classpath.ClassPathResource;

public class RepeatableMain {
    private static Log LOG;
    private static RepeatableFlyway repeatableFlyway;

    static void initLogging(boolean debug) {
        LogFactory.setLogCreator((LogCreator)new ConsoleLogCreator(debug));
        LOG = LogFactory.getLog(RepeatableMain.class);
    }

    public static void main(String[] args) {
        boolean debug = RepeatableMain.isDebug(args);
        RepeatableMain.initLogging(debug);
        try {
            RepeatableMain.printVersion();
            List<String> operations = RepeatableMain.determineOperations(args);
            if (operations.isEmpty()) {
                RepeatableMain.printUsage();
                return;
            }
            Properties properties = new Properties();
            RepeatableMain.initializeDefaults(properties);
            RepeatableMain.loadConfigurationFile(properties, args);
            RepeatableMain.overrideConfiguration(properties, args);
            RepeatableMain.loadJdbcDriversAndJavaMigrations(properties);
            Flyway flyway = new Flyway();
            flyway.configure(properties);
            RepeatableFlyway.configure((Flyway)flyway, (Properties)properties);
            for (String operation : operations) {
                RepeatableMain.executeOperation(flyway, operation);
            }
        }
        catch (Exception e) {
            if (debug) {
                LOG.error("Unexpected error", e);
            } else {
                if (e instanceof FlywayException) {
                    LOG.error(e.getMessage());
                } else {
                    LOG.error(e.toString());
                }
                Throwable cause = ExceptionUtils.getRootCause((Throwable)e);
                LOG.error("Caused by: " + cause.toString());
                RepeatableMain.outputFirstStackTraceElement(cause);
            }
            System.exit(1);
        }
    }

    private static void executeOperation(Flyway flyway, String operation) throws SQLException {
        if ("clean".equals(operation)) {
            flyway.clean();
        } else if ("init".equals(operation)) {
            flyway.init();
        } else if ("migrate".equals(operation)) {
            flyway.migrate();
        } else if ("validate".equals(operation)) {
            flyway.validate();
        } else if ("info".equals(operation)) {
            LOG.info("\n" + MigrationInfoDumper.dumpToAsciiTable((MigrationInfo[])flyway.info().all()));
        } else if ("repair".equals(operation)) {
            flyway.repair();
        } else {
            LOG.error("Invalid operation: " + operation);
            RepeatableMain.printUsage();
            System.exit(1);
        }
    }

    private static boolean isDebug(String[] args) {
        for (String arg : args) {
            if (!"-X".equals(arg)) continue;
            return true;
        }
        return false;
    }

    private static void outputFirstStackTraceElement(Throwable t) {
        StackTraceElement firstStackTraceElement = t.getStackTrace()[0];
        LOG.error("Occured in " + firstStackTraceElement.getClassName() + "." + firstStackTraceElement.getMethodName() + "() at line " + firstStackTraceElement.getLineNumber());
    }

    private static void initializeDefaults(Properties properties) {
        properties.put("flyway.locations", "filesystem:" + RepeatableMain.getInstallationDir() + "/sql");
        properties.put("flyway.jarDir", RepeatableMain.getInstallationDir() + "/jars");
    }

    private static void printVersion() throws IOException {
        String version = new ClassPathResource("version.txt", Thread.currentThread().getContextClassLoader()).loadAsString("UTF-8");
        LOG.info("Flyway (Command-line Tool) v." + version);
        LOG.info("");
    }

    private static void printUsage() {
        LOG.info("********");
        LOG.info("* Usage");
        LOG.info("********");
        LOG.info("");
        LOG.info("flyway [options] command");
        LOG.info("");
        LOG.info("By default, the configuration will be read from conf/flyway.properties.");
        LOG.info("Options passed from the command-line override the configuration.");
        LOG.info("");
        LOG.info("Commands");
        LOG.info("========");
        LOG.info("clean    : Drops all objects in the configured schemas");
        LOG.info("init     : Creates and initializes the metadata table");
        LOG.info("migrate  : Migrates the database");
        LOG.info("validate : Validates the applied migrations against the ones on the classpath");
        LOG.info("info     : Prints the information about applied, current and pending migrations");
        LOG.info("repair   : Repairs the metadata table after a failed migration");
        LOG.info("");
        LOG.info("Options (Format: -key=value)");
        LOG.info("=======");
        LOG.info("driver                 : Fully qualified classname of the jdbc driver");
        LOG.info("url                    : Jdbc url to use to connect to the database");
        LOG.info("user                   : User to use to connect to the database");
        LOG.info("password               : Password to use to connect to the database");
        LOG.info("schemas                : Comma-separated list of the schemas managed by Flyway");
        LOG.info("table                  : Name of Flyway's metadata table");
        LOG.info("locations              : Classpath locations to scan recursively for migrations");
        LOG.info("sqlMigrationPrefix     : File name prefix for Sql migrations");
        LOG.info("sqlMigrationSuffix     : File name suffix for Sql migrations");
        LOG.info("encoding               : Encoding of Sql migrations");
        LOG.info("placeholders           : Placeholders to replace in Sql migrations");
        LOG.info("placeholderPrefix      : Prefix of every placeholder");
        LOG.info("placeholderSuffix      : Suffix of every placeholder");
        LOG.info("target                 : Target version up to which Flyway should migrate");
        LOG.info("outOfOrder             : Allows migrations to be run \"out of order\"");
        LOG.info("validateOnMigrate      : Validate when running migrate");
        LOG.info("cleanOnValidationError : Automatically clean on a validation error");
        LOG.info("initVersion            : Version to tag schema with when executing init");
        LOG.info("initDescription        : Description to tag schema with when executing init");
        LOG.info("initOnMigrate          : Init on migrate against uninitialized non-empty schema");
        LOG.info("configFile             : Config file to use (default: conf/flyway.properties)");
        LOG.info("configFileEncoding     : Encoding of the config file (default: UTF-8)");
        LOG.info("jarDir                 : Dir for Jdbc drivers & Java migrations (default: jars)");
        LOG.info("");
        LOG.info("Add -X to print debug output");
        LOG.info("");
        LOG.info("Example");
        LOG.info("=======");
        LOG.info("flyway -target=1.5 -placeholder.user=my_user info");
        LOG.info("");
        LOG.info("More info at http://flywaydb.org/documentation/commandline");
    }

    private static void loadJdbcDriversAndJavaMigrations(Properties properties) throws IOException {
        String directoryForJdbcDriversAndJavaMigrations = properties.getProperty("flyway.jarDir");
        File dir = new File(directoryForJdbcDriversAndJavaMigrations);
        File[] files = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        });
        if (files == null) {
            LOG.error("Directory for JDBC drivers and JavaMigrations not found: " + directoryForJdbcDriversAndJavaMigrations);
            System.exit(1);
        }
        for (File file : files) {
            RepeatableMain.addJarOrDirectoryToClasspath(file.getPath());
        }
    }

    static void addJarOrDirectoryToClasspath(String name) throws IOException {
        LOG.debug("Adding location to classpath: " + name);
        URLClassLoader urlClassLoader = new URLClassLoader(new URL[]{new File(name).toURI().toURL()}, Thread.currentThread().getContextClassLoader());
        Thread.currentThread().setContextClassLoader(urlClassLoader);
    }

    static void loadConfigurationFile(Properties properties, String[] args) throws FlywayException {
        String configFile = RepeatableMain.determineConfigurationFile(args);
        if (configFile != null) {
            try {
                String encoding = RepeatableMain.determineConfigurationFileEncoding(args);
                InputStreamReader fileReader = new InputStreamReader((InputStream)new FileInputStream(configFile), encoding);
                String propertiesData = FileCopyUtils.copyToString((Reader)fileReader);
                properties.putAll((Map<?, ?>)PropertiesUtils.loadPropertiesFromString((String)propertiesData));
            }
            catch (IOException e) {
                throw new FlywayException("Unable to load config file: " + configFile, (Throwable)e);
            }
        }
    }

    private static String determineConfigurationFile(String[] args) {
        for (String arg : args) {
            if (!RepeatableMain.isPropertyArgument(arg) || !"configFile".equals(RepeatableMain.getArgumentProperty(arg))) continue;
            return RepeatableMain.getArgumentValue(arg);
        }
        return RepeatableMain.getInstallationDir() + "/conf/flyway.properties";
    }

    private static String getInstallationDir() {
        String path = ClassUtils.getLocationOnDisk(RepeatableMain.class);
        return path.substring(0, path.lastIndexOf("/")) + "/..";
    }

    private static String determineConfigurationFileEncoding(String[] args) {
        for (String arg : args) {
            if (!RepeatableMain.isPropertyArgument(arg) || !"configFileEncoding".equals(RepeatableMain.getArgumentProperty(arg))) continue;
            return RepeatableMain.getArgumentValue(arg);
        }
        return "UTF-8";
    }

    static void overrideConfiguration(Properties properties, String[] args) {
        for (String arg : args) {
            if (!RepeatableMain.isPropertyArgument(arg)) continue;
            properties.put("flyway." + RepeatableMain.getArgumentProperty(arg), RepeatableMain.getArgumentValue(arg));
        }
    }

    static boolean isPropertyArgument(String arg) {
        return arg.startsWith("-") && arg.contains("=");
    }

    static String getArgumentProperty(String arg) {
        int index = arg.indexOf("=");
        return arg.substring(1, index);
    }

    static String getArgumentValue(String arg) {
        int index = arg.indexOf("=");
        if (index < 0 || index == arg.length()) {
            return "";
        }
        return arg.substring(index + 1);
    }

    private static List<String> determineOperations(String[] args) {
        ArrayList<String> operations = new ArrayList<String>();
        for (String arg : args) {
            if (arg.startsWith("-")) continue;
            operations.add(arg);
        }
        return operations;
    }
}

