/*
 * Decompiled with CFR 0.152.
 */
package ch.hippmann.androidpublisher.publisher;

import ch.hippmann.androidpublisher.LoggingKt;
import ch.hippmann.androidpublisher.publisher.PlayStore;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J5\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\rJ\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J \u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006H\u0002\u00a8\u0006\u0011"}, d2={"Lch/hippmann/androidpublisher/publisher/VersionCodeGenerator;", "", "()V", "generateVersionCode", "", "packageName", "", "baseFolder", "gradleVersionCode", "", "appVersionCodeKey", "credentialsFile", "Ljava/io/File;", "generateVersionCode$androidpublisher", "getGradlePropertiesFile", "setVersionCodeInGradleProperties", "versionCode", "androidpublisher"})
public final class VersionCodeGenerator {
    public static final VersionCodeGenerator INSTANCE;

    public final void generateVersionCode$androidpublisher(@NotNull String packageName, @NotNull String baseFolder, int gradleVersionCode, @NotNull String appVersionCodeKey, @NotNull File credentialsFile) {
        Intrinsics.checkParameterIsNotNull((Object)packageName, (String)"packageName");
        Intrinsics.checkParameterIsNotNull((Object)baseFolder, (String)"baseFolder");
        Intrinsics.checkParameterIsNotNull((Object)appVersionCodeKey, (String)"appVersionCodeKey");
        Intrinsics.checkParameterIsNotNull((Object)credentialsFile, (String)"credentialsFile");
        int playStoreVersionCode = PlayStore.INSTANCE.getLatestVersionCode$androidpublisher(packageName, credentialsFile);
        LoggingKt.log("Play store version code: " + playStoreVersionCode + ", gradle version code: " + gradleVersionCode);
        boolean bl = false;
        int newVersionCode = Math.max(playStoreVersionCode, gradleVersionCode) + 1;
        LoggingKt.log("New version code for " + packageName + ": " + newVersionCode);
        this.setVersionCodeInGradleProperties(baseFolder, newVersionCode, appVersionCodeKey);
    }

    private final void setVersionCodeInGradleProperties(String baseFolder, int versionCode, String appVersionCodeKey) {
        LoggingKt.log("Writing version code " + versionCode + " to gradle.properties with key: " + appVersionCodeKey);
        File propertiesFile = this.getGradlePropertiesFile(baseFolder);
        Serializable serializable = new Properties();
        boolean bl = false;
        boolean bl2 = false;
        Properties $this$apply = serializable;
        boolean bl3 = false;
        File file = propertiesFile;
        Properties properties = $this$apply;
        boolean bl4 = false;
        FileInputStream fileInputStream = new FileInputStream(file);
        properties.load(fileInputStream);
        Properties properties2 = serializable;
        properties2.setProperty(appVersionCodeKey, String.valueOf(versionCode));
        serializable = propertiesFile;
        Properties properties3 = properties2;
        bl = false;
        FileOutputStream fileOutputStream = new FileOutputStream((File)serializable);
        properties3.store(fileOutputStream, null);
    }

    private final File getGradlePropertiesFile(String baseFolder) {
        return new File(baseFolder + "/gradle.properties");
    }

    private VersionCodeGenerator() {
    }

    static {
        VersionCodeGenerator versionCodeGenerator;
        INSTANCE = versionCodeGenerator = new VersionCodeGenerator();
    }
}

