/*
 * Decompiled with CFR 0.152.
 */
package ch.hippmann.androidpublisher.publisher;

import ch.hippmann.androidpublisher.LoggingKt;
import com.github.doyaaaaaken.kotlincsv.dsl.CsvReaderDslKt;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.FileContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.androidpublisher.AndroidPublisher;
import com.google.api.services.androidpublisher.model.AppEdit;
import com.google.api.services.androidpublisher.model.Bundle;
import com.google.api.services.androidpublisher.model.BundlesListResponse;
import com.google.api.services.androidpublisher.model.DeobfuscationFilesUploadResponse;
import com.google.api.services.androidpublisher.model.LocalizedText;
import com.google.api.services.androidpublisher.model.Track;
import com.google.api.services.androidpublisher.model.TrackRelease;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u001d\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\rJ(\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002JM\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u001dR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lch/hippmann/androidpublisher/publisher/PlayStore;", "", "()V", "MIME_TYPE_APP_BUNDLE_FILE", "", "MIME_TYPE_MAPPING_FILE", "getAndroidPublisher", "Lcom/google/api/services/androidpublisher/AndroidPublisher;", "credentialsFile", "Ljava/io/File;", "getLatestVersionCode", "", "packageName", "getLatestVersionCode$androidpublisher", "getReleaseNotesFromProject", "", "Lcom/google/api/services/androidpublisher/model/LocalizedText;", "releaseNotesFile", "versionCode", "shouldThrowIfNoReleaseNotes", "", "setHttpTimeout", "Lcom/google/api/client/http/HttpRequestInitializer;", "requestInitializer", "upload", "", "appBundleFile", "track", "uploadMappingFile", "upload$androidpublisher", "androidpublisher"})
public final class PlayStore {
    private static final String MIME_TYPE_MAPPING_FILE = "application/octet-stream";
    private static final String MIME_TYPE_APP_BUNDLE_FILE = "application/octet-stream";
    public static final PlayStore INSTANCE;

    /*
     * WARNING - void declaration
     */
    public final void upload$androidpublisher(@NotNull File appBundleFile, @NotNull String packageName, @NotNull String track, boolean uploadMappingFile, @NotNull File credentialsFile, @NotNull File releaseNotesFile, int versionCode, boolean shouldThrowIfNoReleaseNotes) {
        Collection<Long> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        boolean $i$f$log;
        Intrinsics.checkParameterIsNotNull((Object)appBundleFile, (String)"appBundleFile");
        Intrinsics.checkParameterIsNotNull((Object)packageName, (String)"packageName");
        Intrinsics.checkParameterIsNotNull((Object)track, (String)"track");
        Intrinsics.checkParameterIsNotNull((Object)credentialsFile, (String)"credentialsFile");
        Intrinsics.checkParameterIsNotNull((Object)releaseNotesFile, (String)"releaseNotesFile");
        AndroidPublisher.Edits edits = new AndroidPublisher.Edits(this.getAndroidPublisher(credentialsFile));
        Object $this$log$iv = edits.insert(packageName, null).execute();
        boolean $i$f$log2 = false;
        AppEdit appEdit = (AppEdit)$this$log$iv;
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder().append("Created AppEdit with id: ");
        AppEdit appEdit2 = appEdit;
        Intrinsics.checkExpressionValueIsNotNull((Object)appEdit2, (String)"appEdit");
        LoggingKt.log(stringBuilder.append(appEdit2.getId()).toString());
        AppEdit appEdit3 = (AppEdit)$this$log$iv;
        LoggingKt.log("Uploading " + appBundleFile + "...");
        AndroidPublisher.Edits.Bundles bundles = edits.bundles();
        AppEdit appEdit4 = appEdit3;
        Intrinsics.checkExpressionValueIsNotNull((Object)appEdit4, (String)"appEdit");
        Object $this$log$iv2 = bundles.upload(packageName, appEdit4.getId(), (AbstractInputStreamContent)new FileContent("application/octet-stream", appBundleFile)).execute();
        boolean $i$f$log3 = false;
        Bundle it = (Bundle)$this$log$iv2;
        boolean bl22 = false;
        StringBuilder stringBuilder2 = new StringBuilder().append("App bundle with version code ");
        Bundle bundle = it;
        Intrinsics.checkExpressionValueIsNotNull((Object)bundle, (String)"it");
        LoggingKt.log(stringBuilder2.append(bundle.getVersionCode()).append(" uploaded").toString());
        Bundle appBundleUpload = (Bundle)$this$log$iv2;
        if (uploadMappingFile) {
            Object v7;
            boolean $i$f$firstOrNull;
            Sequence $this$firstOrNull$iv;
            block4: {
                LoggingKt.log("Uploading deobfuscation mapping file...");
                File file = appBundleFile.getParentFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"appBundleFile.parentFile");
                $this$firstOrNull$iv = (Sequence)FilesKt.walkTopDown((File)file);
                $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    File it2 = (File)element$iv;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it2.getName(), (Object)"mapping.txt")) continue;
                    v7 = element$iv;
                    break block4;
                }
                v7 = null;
            }
            $this$firstOrNull$iv = v7;
            $i$f$firstOrNull = false;
            bl22 = false;
            if ($this$firstOrNull$iv == null) {
                boolean bl4 = false;
                String bl22 = "No mapping file found in " + appBundleFile.getParentFile() + " for bundle: " + appBundleFile.getName();
                throw (Throwable)new IllegalArgumentException(bl22.toString());
            }
            File mappingFile = (File)$this$firstOrNull$iv;
            FileContent mappingFileContent = new FileContent("application/octet-stream", mappingFile);
            AndroidPublisher.Edits.Deobfuscationfiles deobfuscationfiles = edits.deobfuscationfiles();
            String string = appEdit3.getId();
            Bundle bundle2 = appBundleUpload;
            Intrinsics.checkExpressionValueIsNotNull((Object)bundle2, (String)"appBundleUpload");
            Object $this$log$iv222 = deobfuscationfiles.upload(packageName, string, bundle2.getVersionCode(), "proguard", (AbstractInputStreamContent)mappingFileContent).execute();
            $i$f$log = false;
            DeobfuscationFilesUploadResponse it3 = (DeobfuscationFilesUploadResponse)$this$log$iv222;
            boolean bl5 = false;
            LoggingKt.log("Deobfuscation mapping file for app bundle " + appBundleFile.getName() + " with version code " + appBundleUpload.getVersionCode() + " uploaded");
        }
        LoggingKt.log("Updating track " + track + "...");
        TrackRelease mappingFileContent = new TrackRelease();
        boolean $this$log$iv222 = false;
        $i$f$log = false;
        TrackRelease $this$apply22 = mappingFileContent;
        boolean bl6 = false;
        Bundle bundle3 = appBundleUpload;
        Intrinsics.checkExpressionValueIsNotNull((Object)bundle3, (String)"appBundleUpload");
        Iterable bl3 = CollectionsKt.listOf((Object)bundle3.getVersionCode());
        TrackRelease trackRelease = $this$apply22;
        boolean $i$f$map = false;
        void var21_39 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it4;
            Integer n = (Integer)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl7 = false;
            Long l = it4.intValue();
            collection.add(l);
        }
        collection = (List)destination$iv$iv;
        trackRelease.setVersionCodes((List)collection);
        $this$apply22.setStatus("completed");
        $this$apply22.setReleaseNotes(INSTANCE.getReleaseNotesFromProject(releaseNotesFile, versionCode, shouldThrowIfNoReleaseNotes));
        TrackRelease trackRelease2 = mappingFileContent;
        Object $this$log$iv222 = new Track();
        $i$f$log = false;
        boolean $this$apply22 = false;
        Track $this$apply = $this$log$iv222;
        boolean bl8 = false;
        $this$apply.setTrack(track);
        $this$apply.setReleases(CollectionsKt.listOf((Object)trackRelease2));
        Track trackModel = $this$log$iv222;
        $this$log$iv222 = edits.tracks().update(packageName, appEdit3.getId(), track, trackModel).execute();
        $i$f$log = false;
        Object it5 = $this$log$iv222;
        boolean bl9 = false;
        StringBuilder stringBuilder3 = new StringBuilder().append("Track ");
        Object object = it5;
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"it");
        LoggingKt.log(stringBuilder3.append(object.getTrack()).append(" updated").toString());
        LoggingKt.log("Committing changes...");
        $this$log$iv222 = edits.commit(packageName, appEdit3.getId()).execute();
        $i$f$log = false;
        it5 = (AppEdit)$this$log$iv222;
        boolean bl10 = false;
        StringBuilder stringBuilder4 = new StringBuilder().append("AppEdit with id ");
        Object object2 = it5;
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"it");
        LoggingKt.log(stringBuilder4.append(object2.getId()).append(" has been committed").toString());
    }

    /*
     * WARNING - void declaration
     */
    public final int getLatestVersionCode$androidpublisher(@NotNull String packageName, @NotNull File credentialsFile) {
        Bundle appBundle;
        BundlesListResponse appBundleResponse;
        Intrinsics.checkParameterIsNotNull((Object)packageName, (String)"packageName");
        Intrinsics.checkParameterIsNotNull((Object)credentialsFile, (String)"credentialsFile");
        AndroidPublisher androidPublisher = this.getAndroidPublisher(credentialsFile);
        AndroidPublisher.Edits edits = new AndroidPublisher.Edits(androidPublisher);
        Object $this$log$iv = edits.insert(packageName, null).execute();
        boolean $i$f$log = false;
        AppEdit it = (AppEdit)$this$log$iv;
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder().append("Created app edit with id: ");
        AppEdit appEdit = it;
        Intrinsics.checkExpressionValueIsNotNull((Object)appEdit, (String)"it");
        LoggingKt.log(stringBuilder.append(appEdit.getId()).toString());
        AppEdit appEdit2 = (AppEdit)$this$log$iv;
        AndroidPublisher.Edits.Bundles bundles = edits.bundles();
        AppEdit appEdit3 = appEdit2;
        Intrinsics.checkExpressionValueIsNotNull((Object)appEdit3, (String)"appEdit");
        BundlesListResponse bundlesListResponse = appBundleResponse = (BundlesListResponse)bundles.list(packageName, appEdit3.getId()).execute();
        Intrinsics.checkExpressionValueIsNotNull((Object)bundlesListResponse, (String)"appBundleResponse");
        List list = bundlesListResponse.getBundles();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"appBundleResponse.bundles");
        Iterable $this$reduce$iv = list;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw (Throwable)new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void bundle;
            Bundle bundle2 = (Bundle)iterator$iv.next();
            Bundle acc = (Bundle)accumulator$iv;
            boolean bl2 = false;
            Bundle bundle3 = acc;
            Intrinsics.checkExpressionValueIsNotNull((Object)bundle3, (String)"acc");
            int n = bundle3.getVersionCode();
            void v8 = bundle;
            Intrinsics.checkExpressionValueIsNotNull((Object)v8, (String)"bundle");
            Integer n2 = v8.getVersionCode();
            Intrinsics.checkExpressionValueIsNotNull((Object)n2, (String)"bundle.versionCode");
            accumulator$iv = Intrinsics.compare((int)n, (int)n2) > 0 ? acc : bundle;
        }
        Bundle bundle = appBundle = (Bundle)accumulator$iv;
        Intrinsics.checkExpressionValueIsNotNull((Object)bundle, (String)"appBundle");
        Integer $this$log$iv2 = bundle.getVersionCode();
        boolean $i$f$log2 = false;
        Integer it2 = $this$log$iv2;
        boolean bl3 = false;
        LoggingKt.log("Latest uploaded version code for " + packageName + ": " + it2);
        Integer n = $this$log$iv2;
        Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"appBundle.versionCode.lo\u2026 for $packageName: $it\" }");
        return ((Number)n).intValue();
    }

    private final AndroidPublisher getAndroidPublisher(File credentialsFile) {
        NetHttpTransport newTrustedTransport = GoogleNetHttpTransport.newTrustedTransport();
        File file = credentialsFile;
        boolean bl = false;
        GoogleCredential credential = GoogleCredential.fromStream((InputStream)new FileInputStream(file)).createScoped((Collection)CollectionsKt.listOf((Object)"https://www.googleapis.com/auth/androidpublisher"));
        HttpTransport httpTransport = (HttpTransport)newTrustedTransport;
        JsonFactory jsonFactory = (JsonFactory)JacksonFactory.getDefaultInstance();
        GoogleCredential googleCredential = credential;
        Intrinsics.checkExpressionValueIsNotNull((Object)googleCredential, (String)"credential");
        AndroidPublisher androidPublisher = new AndroidPublisher.Builder(httpTransport, jsonFactory, this.setHttpTimeout((HttpRequestInitializer)googleCredential)).setApplicationName("androidpublisher").build();
        Intrinsics.checkExpressionValueIsNotNull((Object)androidPublisher, (String)"AndroidPublisher.Builder\u2026er\")\n            .build()");
        return androidPublisher;
    }

    private final HttpRequestInitializer setHttpTimeout(HttpRequestInitializer requestInitializer) {
        return new HttpRequestInitializer(requestInitializer){
            final /* synthetic */ HttpRequestInitializer $requestInitializer;

            public final void initialize(HttpRequest httpRequest) {
                this.$requestInitializer.initialize(httpRequest);
                HttpRequest httpRequest2 = httpRequest;
                Intrinsics.checkExpressionValueIsNotNull((Object)httpRequest2, (String)"httpRequest");
                httpRequest2.setConnectTimeout(120000);
                httpRequest.setReadTimeout(120000);
            }
            {
                this.$requestInitializer = httpRequestInitializer;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private final List<LocalizedText> getReleaseNotesFromProject(File releaseNotesFile, int versionCode, boolean shouldThrowIfNoReleaseNotes) {
        List list;
        if (releaseNotesFile.exists() && Intrinsics.areEqual((Object)FilesKt.getExtension((File)releaseNotesFile), (Object)"csv")) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = CsvReaderDslKt.csvReader$default(null, (int)1, null).readAllWithHeader(releaseNotesFile);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Object object;
                Object object2;
                Iterable $this$mapTo$iv$iv2;
                boolean bl;
                int n;
                Iterable $this$filterIndexedTo$iv$iv;
                void row;
                Map map = (Map)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                String version = (String)CollectionsKt.first((Iterable)row.values());
                Iterable $this$filterIndexed$iv = row.entrySet();
                boolean $i$f$filterIndexed = false;
                Iterable iterable2 = $this$filterIndexed$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterIndexedTo = false;
                void $this$forEachIndexed$iv$iv$iv = $this$filterIndexedTo$iv$iv;
                boolean $i$f$forEachIndexed = false;
                int index$iv$iv$iv2 = 0;
                for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
                    void element$iv$iv;
                    n = index$iv$iv$iv2++;
                    bl = false;
                    if (n < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    int n2 = n;
                    Object t = item$iv$iv$iv;
                    int index$iv$iv = n2;
                    boolean bl3 = false;
                    Map.Entry entry = (Map.Entry)element$iv$iv;
                    int index = index$iv$iv;
                    boolean bl4 = false;
                    if (!(index != 0)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                Iterable $this$map$iv2 = (List)destination$iv$iv2;
                boolean $i$f$map2 = false;
                $this$filterIndexedTo$iv$iv = $this$map$iv2;
                destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    void languageToReleaseNote;
                    Map.Entry index$iv$iv$iv2 = (Map.Entry)item$iv$iv2;
                    object2 = destination$iv$iv2;
                    boolean bl5 = false;
                    LocalizedText localizedText = new LocalizedText();
                    n = 0;
                    bl = false;
                    LocalizedText $this$apply = localizedText;
                    boolean bl6 = false;
                    $this$apply.setLanguage((String)languageToReleaseNote.getKey());
                    $this$apply.setText((String)languageToReleaseNote.getValue());
                    object = localizedText;
                    object2.add(object);
                }
                List releaseNotes = (List)destination$iv$iv2;
                $this$map$iv2 = releaseNotes;
                object2 = new StringBuilder().append("Found release notes for version ").append(version).append(" with languages: ");
                $i$f$map2 = false;
                $this$mapTo$iv$iv2 = $this$map$iv2;
                destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                $i$f$mapTo2 = false;
                for (Object item$iv$iv3 : $this$mapTo$iv$iv2) {
                    void it;
                    LocalizedText languageToReleaseNote = (LocalizedText)item$iv$iv3;
                    object = destination$iv$iv2;
                    boolean bl7 = false;
                    String string = it.getLanguage();
                    object.add(string);
                }
                object = (List)destination$iv$iv2;
                LoggingKt.log(((StringBuilder)object2).append(object).toString());
                Pair pair = new Pair((Object)version, (Object)releaseNotes);
                collection.add(pair);
            }
            list = (List)MapsKt.toMap((Iterable)((List)destination$iv$iv)).get(String.valueOf(versionCode));
            if (list == null) {
                if (shouldThrowIfNoReleaseNotes) {
                    throw (Throwable)new IllegalStateException("There are no release notes present for the AppVersion " + versionCode + "! Looked in File " + releaseNotesFile);
                }
                LoggingKt.log("No release notes found for version " + versionCode + "! Continuing with no release notes as configured...");
                list = null;
            }
        } else {
            if (shouldThrowIfNoReleaseNotes) {
                throw (Throwable)new IllegalStateException("There are no release notes present for the AppVersion " + versionCode + "! Looked in File " + releaseNotesFile);
            }
            LoggingKt.log("No release notes found for version " + versionCode + "! Continuing with no release notes as configured...");
            list = null;
        }
        return list;
    }

    private PlayStore() {
    }

    static {
        PlayStore playStore;
        INSTANCE = playStore = new PlayStore();
    }
}

