/*
 * Decompiled with CFR 0.152.
 */
package ch.frostnova.util.check;

import ch.frostnova.util.check.Check;
import java.util.function.Function;
import java.util.function.Predicate;

@FunctionalInterface
public interface Verify<T> {
    public void check(T var1) throws Exception;

    public static <T> Verify<T> that(Predicate<? super T> test, String message) {
        return Verify.that(test, (? super T value) -> message);
    }

    public static <T> Verify<T> that(Predicate<? super T> test, Function<? super T, String> messageProducer) {
        Check.required(test, "test", new Verify[0]);
        Check.required(messageProducer, "messageProducer", new Verify[0]);
        return value -> {
            try {
                if (!test.test(value)) {
                    throw new IllegalArgumentException((String)messageProducer.apply(value));
                }
            }
            catch (Exception ex) {
                throw new IllegalArgumentException((String)messageProducer.apply(value), ex);
            }
        };
    }
}

