/*
 * Decompiled with CFR 0.152.
 */
package ch.frostnova.util.check;

import ch.frostnova.util.check.Verify;
import java.util.Collection;
import java.util.Objects;

public final class CheckCollection {
    private CheckCollection() {
    }

    public static Verify<Collection> notEmpty() {
        return Verify.that(c -> !c.isEmpty(), "must not be empty");
    }

    public static Verify<Collection> noNullElements() {
        return Verify.that(c -> c.stream().noneMatch(Objects::isNull), "must not be empty");
    }

    public static Verify<Collection> min(int min) {
        return Verify.that(v -> v.size() >= min, "must have at least " + min + " elements");
    }

    public static Verify<Collection> max(int max) {
        return Verify.that(v -> v.size() <= max, "must have no more than " + max + " elements");
    }
}

