/*
 * Decompiled with CFR 0.152.
 */
package ch.frostnova.util.check;

import ch.frostnova.util.check.Verify;

public final class Check {
    private Check() {
    }

    @SafeVarargs
    public static <T> T optional(T value, String parameterName, Verify<? super T> ... verifiers) {
        return value == null ? null : (T)Check.required(value, parameterName, verifiers);
    }

    @SafeVarargs
    public static <T> T required(T value, String parameterName, Verify<? super T> ... verifiers) {
        if (value == null) {
            throw new IllegalArgumentException(Check.name(parameterName) + " is required");
        }
        if (verifiers != null) {
            for (Verify<T> verify : verifiers) {
                try {
                    verify.check(value);
                }
                catch (Exception ex) {
                    String message = ex.getMessage() != null ? ex.getMessage() : "unknown reason";
                    throw new IllegalArgumentException(Check.name(parameterName) + " " + message, ex);
                }
            }
        }
        return value;
    }

    private static String name(String parameterName) {
        return parameterName != null ? "'" + parameterName + "'" : "value";
    }
}

